/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.testutil.DummyStreamsConfig;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TopologyMetadataTest {
    static final String TOPOLOGY1 = "topology1";
    static final String TOPOLOGY2 = "topology2";

    @Test
    public void testPauseResume() {
        InternalTopologyBuilder internalTopologyBuilder = (InternalTopologyBuilder)EasyMock.mock(InternalTopologyBuilder.class);
        DummyStreamsConfig config = new DummyStreamsConfig();
        TopologyMetadata topologyMetadata = new TopologyMetadata(internalTopologyBuilder, (StreamsConfig)config);
        Assert.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY1));
        Assert.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY2));
        topologyMetadata.pauseTopology(TOPOLOGY1);
        Assert.assertTrue((boolean)topologyMetadata.isPaused(TOPOLOGY1));
        Assert.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY2));
        topologyMetadata.resumeTopology(TOPOLOGY1);
        Assert.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY1));
        Assert.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY2));
    }
}

