/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.ReadOnlyWindowStoreFacade;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class ReadOnlyWindowStoreFacadeTest {
    @Mock
    private TimestampedWindowStore<String, String> mockedWindowTimestampStore;
    @Mock
    private WindowStoreIterator<ValueAndTimestamp<String>> mockedWindowTimestampIterator;
    @Mock
    private KeyValueIterator<Windowed<String>, ValueAndTimestamp<String>> mockedKeyValueWindowTimestampIterator;
    private ReadOnlyWindowStoreFacade<String, String> readOnlyWindowStoreFacade;

    @Before
    public void setup() {
        this.readOnlyWindowStoreFacade = new ReadOnlyWindowStoreFacade(this.mockedWindowTimestampStore);
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnSingleKeyFetch() {
        EasyMock.expect((Object)this.mockedWindowTimestampStore.fetch((Object)"key1", 21L)).andReturn((Object)ValueAndTimestamp.make((Object)"value1", (long)42L));
        EasyMock.expect((Object)this.mockedWindowTimestampStore.fetch((Object)"unknownKey", 21L)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.mockedWindowTimestampStore});
        MatcherAssert.assertThat((Object)this.readOnlyWindowStoreFacade.fetch((Object)"key1", 21L), (Matcher)Matchers.is((Object)"value1"));
        Assert.assertNull((Object)this.readOnlyWindowStoreFacade.fetch((Object)"unknownKey", 21L));
        EasyMock.verify((Object[])new Object[]{this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnSingleKeyFetchLongParameters() {
        EasyMock.expect((Object)this.mockedWindowTimestampIterator.next()).andReturn((Object)KeyValue.pair((Object)21L, (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).andReturn((Object)KeyValue.pair((Object)42L, (Object)ValueAndTimestamp.make((Object)"value2", (long)23L)));
        EasyMock.expect((Object)this.mockedWindowTimestampStore.fetch((Object)"key1", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L))).andReturn(this.mockedWindowTimestampIterator);
        EasyMock.replay((Object[])new Object[]{this.mockedWindowTimestampIterator, this.mockedWindowTimestampStore});
        WindowStoreIterator iterator = this.readOnlyWindowStoreFacade.fetch((Object)"key1", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)21L, (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)42L, (Object)"value2")));
        EasyMock.verify((Object[])new Object[]{this.mockedWindowTimestampIterator, this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnSingleKeyFetchInstantParameters() {
        EasyMock.expect((Object)this.mockedWindowTimestampIterator.next()).andReturn((Object)KeyValue.pair((Object)21L, (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).andReturn((Object)KeyValue.pair((Object)42L, (Object)ValueAndTimestamp.make((Object)"value2", (long)23L)));
        EasyMock.expect((Object)this.mockedWindowTimestampStore.fetch((Object)"key1", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L))).andReturn(this.mockedWindowTimestampIterator);
        EasyMock.replay((Object[])new Object[]{this.mockedWindowTimestampIterator, this.mockedWindowTimestampStore});
        WindowStoreIterator iterator = this.readOnlyWindowStoreFacade.fetch((Object)"key1", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)21L, (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)42L, (Object)"value2")));
        EasyMock.verify((Object[])new Object[]{this.mockedWindowTimestampIterator, this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnRangeFetchLongParameters() {
        EasyMock.expect((Object)this.mockedKeyValueWindowTimestampIterator.next()).andReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).andReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)ValueAndTimestamp.make((Object)"value2", (long)100L)));
        EasyMock.expect((Object)this.mockedWindowTimestampStore.fetch((Object)"key1", (Object)"key2", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L))).andReturn(this.mockedKeyValueWindowTimestampIterator);
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueWindowTimestampIterator, this.mockedWindowTimestampStore});
        KeyValueIterator iterator = this.readOnlyWindowStoreFacade.fetch((Object)"key1", (Object)"key2", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)"value2")));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueWindowTimestampIterator, this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnRangeFetchInstantParameters() {
        EasyMock.expect((Object)this.mockedKeyValueWindowTimestampIterator.next()).andReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).andReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)ValueAndTimestamp.make((Object)"value2", (long)100L)));
        EasyMock.expect((Object)this.mockedWindowTimestampStore.fetch((Object)"key1", (Object)"key2", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L))).andReturn(this.mockedKeyValueWindowTimestampIterator);
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueWindowTimestampIterator, this.mockedWindowTimestampStore});
        KeyValueIterator iterator = this.readOnlyWindowStoreFacade.fetch((Object)"key1", (Object)"key2", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)"value2")));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueWindowTimestampIterator, this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnFetchAllLongParameters() {
        EasyMock.expect((Object)this.mockedKeyValueWindowTimestampIterator.next()).andReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).andReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)ValueAndTimestamp.make((Object)"value2", (long)100L)));
        EasyMock.expect((Object)this.mockedWindowTimestampStore.fetchAll(Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L))).andReturn(this.mockedKeyValueWindowTimestampIterator);
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueWindowTimestampIterator, this.mockedWindowTimestampStore});
        KeyValueIterator iterator = this.readOnlyWindowStoreFacade.fetchAll(Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)"value2")));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueWindowTimestampIterator, this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnFetchAllInstantParameters() {
        EasyMock.expect((Object)this.mockedKeyValueWindowTimestampIterator.next()).andReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).andReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)ValueAndTimestamp.make((Object)"value2", (long)100L)));
        EasyMock.expect((Object)this.mockedWindowTimestampStore.fetchAll(Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L))).andReturn(this.mockedKeyValueWindowTimestampIterator);
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueWindowTimestampIterator, this.mockedWindowTimestampStore});
        KeyValueIterator iterator = this.readOnlyWindowStoreFacade.fetchAll(Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)"value2")));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueWindowTimestampIterator, this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnAll() {
        EasyMock.expect((Object)this.mockedKeyValueWindowTimestampIterator.next()).andReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).andReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)ValueAndTimestamp.make((Object)"value2", (long)100L)));
        EasyMock.expect((Object)this.mockedWindowTimestampStore.all()).andReturn(this.mockedKeyValueWindowTimestampIterator);
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueWindowTimestampIterator, this.mockedWindowTimestampStore});
        KeyValueIterator iterator = this.readOnlyWindowStoreFacade.all();
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)"value2")));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueWindowTimestampIterator, this.mockedWindowTimestampStore});
    }
}

