/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.test.GenericInMemoryKeyValueStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelegatingPeekingKeyValueIteratorTest {
    private final String name = "name";
    private KeyValueStore<String, String> store;

    @Before
    public void setUp() {
        this.store = new GenericInMemoryKeyValueStore<String, String>("name");
    }

    @Test
    public void shouldPeekNextKey() {
        this.store.put((Object)"A", (Object)"A");
        DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());
        Assert.assertEquals((Object)"A", (Object)peekingIterator.peekNextKey());
        Assert.assertEquals((Object)"A", (Object)peekingIterator.peekNextKey());
        Assert.assertTrue((boolean)peekingIterator.hasNext());
        peekingIterator.close();
    }

    @Test
    public void shouldPeekNext() {
        this.store.put((Object)"A", (Object)"A");
        DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());
        Assert.assertEquals((Object)KeyValue.pair((Object)"A", (Object)"A"), (Object)peekingIterator.peekNext());
        Assert.assertEquals((Object)KeyValue.pair((Object)"A", (Object)"A"), (Object)peekingIterator.peekNext());
        Assert.assertTrue((boolean)peekingIterator.hasNext());
        peekingIterator.close();
    }

    @Test
    public void shouldPeekAndIterate() {
        String[] kvs;
        for (String kv : kvs = new String[]{"a", "b", "c", "d", "e", "f"}) {
            this.store.put((Object)kv, (Object)kv);
        }
        DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());
        int index = 0;
        while (peekingIterator.hasNext()) {
            String peekNext = (String)peekingIterator.peekNextKey();
            String key = (String)peekingIterator.next().key;
            Assert.assertEquals((Object)kvs[index], (Object)peekNext);
            Assert.assertEquals((Object)kvs[index], (Object)key);
            ++index;
        }
        Assert.assertEquals((long)kvs.length, (long)index);
        peekingIterator.close();
    }

    @Test
    public void shouldThrowNoSuchElementWhenNoMoreItemsLeftAndNextCalled() {
        try (DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());){
            Assert.assertThrows(NoSuchElementException.class, () -> ((DelegatingPeekingKeyValueIterator)peekingIterator).next());
        }
    }

    @Test
    public void shouldThrowNoSuchElementWhenNoMoreItemsLeftAndPeekNextCalled() {
        try (DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());){
            Assert.assertThrows(NoSuchElementException.class, () -> ((DelegatingPeekingKeyValueIterator)peekingIterator).peekNextKey());
        }
    }
}

