/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.streams.processor.internals.StreamThreadTotalBlockedTime;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class StreamThreadTotalBlockedTimeTest {
    private static final int IO_TIME_TOTAL = 1;
    private static final int IO_WAIT_TIME_TOTAL = 2;
    private static final int COMMITTED_TIME_TOTAL = 3;
    private static final int COMMIT_SYNC_TIME_TOTAL = 4;
    private static final int RESTORE_IOTIME_TOTAL = 5;
    private static final int RESTORE_IO_WAITTIME_TOTAL = 6;
    private static final double PRODUCER_BLOCKED_TIME = 7.0;
    @Mock
    Consumer<?, ?> consumer;
    @Mock
    Consumer<?, ?> restoreConsumer;
    @Mock
    Supplier<Double> producerBlocked;
    private StreamThreadTotalBlockedTime blockedTime;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();

    @Before
    public void setup() {
        this.blockedTime = new StreamThreadTotalBlockedTime(this.consumer, this.restoreConsumer, this.producerBlocked);
        Mockito.when((Object)this.consumer.metrics()).thenAnswer(a -> new MetricsBuilder().addMetric("io-time-ns-total", 1.0).addMetric("io-wait-time-ns-total", 2.0).addMetric("committed-time-ns-total", 3.0).addMetric("commit-sync-time-ns-total", 4.0).build());
        Mockito.when((Object)this.restoreConsumer.metrics()).thenAnswer(a -> new MetricsBuilder().addMetric("io-time-ns-total", 5.0).addMetric("io-wait-time-ns-total", 6.0).build());
        Mockito.when((Object)this.producerBlocked.get()).thenReturn((Object)7.0);
    }

    @Test
    public void shouldComputeTotalBlockedTime() {
        MatcherAssert.assertThat((Object)this.blockedTime.compute(), (Matcher)Matchers.equalTo((Object)28.0));
    }

    private static class MetricsBuilder {
        private final HashMap<MetricName, Metric> metrics = new HashMap();

        private MetricsBuilder() {
        }

        private MetricsBuilder addMetric(String name, final double value) {
            final MetricName metricName = new MetricName(name, "", "", Collections.emptyMap());
            this.metrics.put(metricName, new Metric(){

                public MetricName metricName() {
                    return metricName;
                }

                public Object metricValue() {
                    return value;
                }
            });
            return this;
        }

        public Map<MetricName, ? extends Metric> build() {
            return Collections.unmodifiableMap(this.metrics);
        }
    }
}

