/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Map;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.junit.Assert;
import org.junit.Test;

public class TimeWindowTest {
    private final long start = 50L;
    private final long end = 100L;
    private final TimeWindow window = new TimeWindow(50L, 100L);
    private final SessionWindow sessionWindow = new SessionWindow(50L, 100L);

    @Test
    public void endMustBeLargerThanStart() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new TimeWindow(50L, 50L));
    }

    @Test
    public void shouldNotOverlapIfOtherWindowIsBeforeThisWindow() {
        Assert.assertFalse((boolean)this.window.overlap((Window)new TimeWindow(0L, 25L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new TimeWindow(0L, 49L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new TimeWindow(0L, 50L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowEndIsWithinThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(0L, 51L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(0L, 75L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(0L, 99L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(49L, 51L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(49L, 75L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(49L, 99L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowContainsThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(0L, 100L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(0L, 101L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(0L, 150L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(49L, 100L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(49L, 101L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(49L, 150L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(50L, 100L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(50L, 101L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(50L, 150L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowIsWithinThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(50L, 75L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(50L, 100L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(75L, 100L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowStartIsWithinThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(50L, 101L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(50L, 150L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(75L, 101L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new TimeWindow(75L, 150L)));
    }

    @Test
    public void shouldNotOverlapIsOtherWindowIsAfterThisWindow() {
        Assert.assertFalse((boolean)this.window.overlap((Window)new TimeWindow(100L, 101L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new TimeWindow(100L, 150L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new TimeWindow(101L, 150L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new TimeWindow(125L, 150L)));
    }

    @Test
    public void cannotCompareTimeWindowWithDifferentWindowType() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.window.overlap((Window)this.sessionWindow));
    }

    @Test
    public void shouldReturnMatchedWindowsOrderedByTimestamp() {
        TimeWindows windows = TimeWindows.of((Duration)Duration.ofMillis(12L)).advanceBy(Duration.ofMillis(5L));
        Map matched = windows.windowsFor(21L);
        Long[] expected = matched.keySet().toArray(new Long[0]);
        Assert.assertEquals((long)expected[0], (long)10L);
        Assert.assertEquals((long)expected[1], (long)15L);
        Assert.assertEquals((long)expected[2], (long)20L);
    }
}

