/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KStreamMapValuesTest {
    private final String topicName = "topic";
    private final MockApiProcessorSupplier<Integer, Integer, Void, Void> supplier = new MockApiProcessorSupplier();
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());

    @Test
    public void testFlatMapValues() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        stream.mapValues(CharSequence::length).process(this.supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedKey : expectedKeys) {
                TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
                inputTopic.pipeInput((Object)expectedKey, (Object)Integer.toString(expectedKey), (long)expectedKey / 2L);
            }
        }
        Object[] expected = new KeyValueTimestamp[]{new KeyValueTimestamp<Integer, Integer>(1, 1, 0L), new KeyValueTimestamp<Integer, Integer>(10, 2, 5L), new KeyValueTimestamp<Integer, Integer>(100, 3, 50L), new KeyValueTimestamp<Integer, Integer>(1000, 4, 500L)};
        Assert.assertArrayEquals((Object[])expected, (Object[])this.supplier.theCapturedProcessor().processed().toArray());
    }

    @Test
    public void testMapValuesWithKeys() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueMapperWithKey mapper = (readOnlyKey, value) -> value.length() + readOnlyKey;
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        stream.mapValues(mapper).process(this.supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
            for (int expectedKey : expectedKeys) {
                inputTopic.pipeInput((Object)expectedKey, (Object)Integer.toString(expectedKey), (long)expectedKey / 2L);
            }
        }
        Object[] expected = new KeyValueTimestamp[]{new KeyValueTimestamp<Integer, Integer>(1, 2, 0L), new KeyValueTimestamp<Integer, Integer>(10, 12, 5L), new KeyValueTimestamp<Integer, Integer>(100, 103, 50L), new KeyValueTimestamp<Integer, Integer>(1000, 1004, 500L)};
        Assert.assertArrayEquals((Object[])expected, (Object[])this.supplier.theCapturedProcessor().processed().toArray());
    }
}

