/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import org.apache.kafka.streams.EqualityCheck;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.junit.Assert;
import org.junit.Test;

public class SessionWindowsTest {
    private static final long ANY_SIZE = 123L;
    private static final long ANY_OTHER_SIZE = 456L;
    private static final long ANY_GRACE = 1024L;

    @Test
    public void shouldSetWindowGap() {
        long anyGap = 42L;
        Assert.assertEquals((long)42L, (long)SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(42L)).inactivityGap());
        Assert.assertEquals((long)42L, (long)SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(42L), (Duration)Duration.ofMillis(1024L)).inactivityGap());
    }

    @Test
    public void gracePeriodShouldEnforceBoundaries() {
        SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(0L));
        try {
            SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(-1L));
            Assert.fail((String)"should not accept negatives");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void noGraceAPIShouldNotSetGracePeriod() {
        Assert.assertEquals((long)0L, (long)SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(3L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(123L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(456L)).gracePeriodMs());
    }

    @Test
    public void withGraceAPIShouldSetGracePeriod() {
        Assert.assertEquals((long)1024L, (long)SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(1024L)).gracePeriodMs());
        Assert.assertEquals((long)1024L, (long)SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(123L), (Duration)Duration.ofMillis(1024L)).gracePeriodMs());
        Assert.assertEquals((long)1024L, (long)SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(456L), (Duration)Duration.ofMillis(1024L)).gracePeriodMs());
    }

    @Test
    public void oldAPIShouldSetDefaultGracePeriod() {
        Assert.assertEquals((long)Duration.ofDays(1L).toMillis(), (long)86400000L);
        Assert.assertEquals((long)86399997L, (long)SessionWindows.with((Duration)Duration.ofMillis(3L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)SessionWindows.with((Duration)Duration.ofMillis(86400000L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)SessionWindows.with((Duration)Duration.ofMillis(86400001L)).gracePeriodMs());
    }

    @Test
    public void windowSizeMustNotBeNegative() {
        Assert.assertThrows(IllegalArgumentException.class, () -> SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(-1L)));
    }

    @Test
    public void windowSizeMustNotBeZero() {
        Assert.assertThrows(IllegalArgumentException.class, () -> SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(0L)));
    }

    @Test
    public void graceShouldNotCalledAfterGraceSet() {
        Assert.assertThrows(IllegalStateException.class, () -> SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(10L)).grace(Duration.ofMillis(10L)));
        Assert.assertThrows(IllegalStateException.class, () -> SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(10L)).grace(Duration.ofMillis(10L)));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForPositiveCases() {
        EqualityCheck.verifyEquality(SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(1L)), SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(1L)));
        EqualityCheck.verifyEquality(SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(11L)), SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(11L)));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForNegativeCases() {
        EqualityCheck.verifyInEquality(SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(9L)), SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(1L)));
        EqualityCheck.verifyInEquality(SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(9L), (Duration)Duration.ofMillis(9L)), SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(9L)));
        EqualityCheck.verifyInEquality(SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(9L)), SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(6L)));
    }
}

