/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WindowStoreIteratorWrapper;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class RocksDBWindowStore
extends WrappedStateStore<SegmentedBytesStore, Object, Object>
implements WindowStore<Bytes, byte[]> {
    private final boolean retainDuplicates;
    private final long windowSize;
    private int seqnum = 0;

    RocksDBWindowStore(SegmentedBytesStore bytesStore, boolean retainDuplicates, long windowSize) {
        super(bytesStore);
        this.retainDuplicates = retainDuplicates;
        this.windowSize = windowSize;
    }

    @Override
    public void put(Bytes key, byte[] value, long windowStartTimestamp) {
        if (value != null || !this.retainDuplicates) {
            this.maybeUpdateSeqnumForDups();
            ((SegmentedBytesStore)this.wrapped()).put(WindowKeySchema.toStoreKeyBinary(key, windowStartTimestamp, this.seqnum), value);
        }
    }

    @Override
    public byte[] fetch(Bytes key, long timestamp) {
        return ((SegmentedBytesStore)this.wrapped()).get(WindowKeySchema.toStoreKeyBinary(key, timestamp, this.seqnum));
    }

    @Override
    public WindowStoreIterator<byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).fetch(key, timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize).valuesIterator();
    }

    @Override
    public WindowStoreIterator<byte[]> backwardFetch(Bytes key, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).backwardFetch(key, timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize).valuesIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).fetch(keyFrom, keyTo, timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).backwardFetch(keyFrom, keyTo, timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).all();
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardAll() {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).backwardAll();
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).fetchAll(timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetchAll(long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).backwardFetchAll(timeFrom, timeTo);
        return new WindowStoreIteratorWrapper(bytesIterator, this.windowSize).keyValueIterator();
    }

    private void maybeUpdateSeqnumForDups() {
        if (this.retainDuplicates) {
            this.seqnum = this.seqnum + 1 & Integer.MAX_VALUE;
        }
    }
}

