/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamAggregate<KIn, VIn, VAgg>
implements KStreamAggProcessorSupplier<KIn, VIn, KIn, VAgg> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamAggregate.class);
    private final String storeName;
    private final Initializer<VAgg> initializer;
    private final Aggregator<? super KIn, ? super VIn, VAgg> aggregator;
    private boolean sendOldValues = false;

    KStreamAggregate(String storeName, Initializer<VAgg> initializer, Aggregator<? super KIn, ? super VIn, VAgg> aggregator) {
        this.storeName = storeName;
        this.initializer = initializer;
        this.aggregator = aggregator;
    }

    @Override
    public Processor<KIn, VIn, KIn, Change<VAgg>> get() {
        return new KStreamAggregateProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<KIn, VAgg> view() {
        return new KTableValueGetterSupplier<KIn, VAgg>(){

            @Override
            public KTableValueGetter<KIn, VAgg> get() {
                return new KStreamAggregateValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamAggregate.this.storeName};
            }
        };
    }

    private class KStreamAggregateValueGetter
    implements KTableValueGetter<KIn, VAgg> {
        private TimestampedKeyValueStore<KIn, VAgg> store;

        private KStreamAggregateValueGetter() {
        }

        @Override
        public void init(org.apache.kafka.streams.processor.ProcessorContext context) {
            this.store = (TimestampedKeyValueStore)context.getStateStore(KStreamAggregate.this.storeName);
        }

        @Override
        public ValueAndTimestamp<VAgg> get(KIn key) {
            return (ValueAndTimestamp)this.store.get(key);
        }
    }

    private class KStreamAggregateProcessor
    extends ContextualProcessor<KIn, VIn, KIn, Change<VAgg>> {
        private TimestampedKeyValueStore<KIn, VAgg> store;
        private Sensor droppedRecordsSensor;
        private TimestampedTupleForwarder<KIn, VAgg> tupleForwarder;

        private KStreamAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext<KIn, Change<VAgg>> context) {
            super.init(context);
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), (StreamsMetricsImpl)context.metrics());
            this.store = (TimestampedKeyValueStore)context.getStateStore(KStreamAggregate.this.storeName);
            this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new TimestampedCacheFlushListener(context), KStreamAggregate.this.sendOldValues);
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            long newTimestamp;
            if (record.key() == null || record.value() == null) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    LOG.warn("Skipping record due to null key or value. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                } else {
                    LOG.warn("Skipping record due to null key or value. Topic, partition, and offset not known.");
                }
                this.droppedRecordsSensor.record();
                return;
            }
            ValueAndTimestamp oldAggAndTimestamp = (ValueAndTimestamp)this.store.get(record.key());
            Object oldAgg = ValueAndTimestamp.getValueOrNull(oldAggAndTimestamp);
            if (oldAgg == null) {
                oldAgg = KStreamAggregate.this.initializer.apply();
                newTimestamp = record.timestamp();
            } else {
                oldAgg = oldAggAndTimestamp.value();
                newTimestamp = Math.max(record.timestamp(), oldAggAndTimestamp.timestamp());
            }
            Object newAgg = KStreamAggregate.this.aggregator.apply(record.key(), record.value(), oldAgg);
            this.store.put(record.key(), ValueAndTimestamp.make(newAgg, newTimestamp));
            this.tupleForwarder.maybeForward(record.key(), newAgg, KStreamAggregate.this.sendOldValues ? oldAgg : null, newTimestamp);
        }
    }
}

