/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public final class Sensors {
    private Sensors() {
    }

    public static Sensor createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel level, String operation, StreamsMetricsImpl metrics, String metricsGroup, String taskName, String storeName, Map<String, String> taskTags, Map<String, String> storeTags) {
        Sensor taskSensor = metrics.taskLevelSensor(taskName, operation, level, new Sensor[0]);
        StreamsMetricsImpl.addAvgMaxLatency(taskSensor, metricsGroup, taskTags, operation);
        StreamsMetricsImpl.addInvocationRateAndCount(taskSensor, metricsGroup, taskTags, operation);
        Sensor sensor = metrics.storeLevelSensor(taskName, storeName, operation, level, taskSensor);
        StreamsMetricsImpl.addAvgMaxLatency(sensor, metricsGroup, storeTags, operation);
        StreamsMetricsImpl.addInvocationRateAndCount(sensor, metricsGroup, storeTags, operation);
        return sensor;
    }

    public static Sensor createBufferSizeSensor(StateStore store, InternalProcessorContext context) {
        return Sensors.getBufferSizeOrCountSensor(store, context, "size");
    }

    public static Sensor createBufferCountSensor(StateStore store, InternalProcessorContext context) {
        return Sensors.getBufferSizeOrCountSensor(store, context, "count");
    }

    private static Sensor getBufferSizeOrCountSensor(StateStore store, InternalProcessorContext context, String property) {
        StreamsMetricsImpl metrics = context.metrics();
        String sensorName = "suppression-buffer-" + property;
        Sensor sensor = metrics.storeLevelSensor(context.taskId().toString(), store.name(), sensorName, Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        String metricsGroup = "stream-buffer-metrics";
        Map<String, String> tags = metrics.tagMap("task-id", context.taskId().toString(), "buffer-id", store.name());
        sensor.add(new MetricName(sensorName + "-current", "stream-buffer-metrics", "The current " + property + " of buffered records.", tags), (MeasurableStat)new Value());
        sensor.add(new MetricName(sensorName + "-avg", "stream-buffer-metrics", "The average " + property + " of buffered records.", tags), (MeasurableStat)new Avg());
        sensor.add(new MetricName(sensorName + "-max", "stream-buffer-metrics", "The max " + property + " of buffered records.", tags), (MeasurableStat)new Max());
        return sensor;
    }
}

