/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.time.Duration;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KStream;

public class ShutdownDeadlockTest {
    private final String kafka;

    public ShutdownDeadlockTest(String kafka) {
        this.kafka = kafka;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        String topic = "source";
        Properties props = new Properties();
        props.setProperty("application.id", "shouldNotDeadlock");
        props.setProperty("bootstrap.servers", this.kafka);
        StreamsBuilder builder = new StreamsBuilder();
        KStream source = builder.stream("source", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        source.foreach((ForeachAction)new ForeachAction<String, String>(){

            public void apply(String key, String value) {
                throw new RuntimeException("KABOOM!");
            }
        });
        final KafkaStreams streams = new KafkaStreams(builder.build(), props);
        streams.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Exit.exit((int)1);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                streams.close(Duration.ofSeconds(5L));
            }
        }));
        Properties producerProps = new Properties();
        producerProps.put("client.id", "SmokeTest");
        producerProps.put("bootstrap.servers", this.kafka);
        producerProps.put("key.serializer", StringSerializer.class);
        producerProps.put("value.serializer", StringSerializer.class);
        KafkaProducer producer = new KafkaProducer(producerProps);
        producer.send(new ProducerRecord("source", (Object)"a", (Object)"a"));
        producer.flush();
        streams.start();
        ShutdownDeadlockTest shutdownDeadlockTest = this;
        synchronized (shutdownDeadlockTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

