/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessorContextTest {
    private ProcessorContext context;

    @Before
    public void prepare() {
        StreamsConfig streamsConfig = (StreamsConfig)EasyMock.mock(StreamsConfig.class);
        EasyMock.expect((Object)streamsConfig.getString("application.id")).andReturn((Object)"add-id");
        EasyMock.expect((Object)streamsConfig.defaultValueSerde()).andReturn((Object)Serdes.ByteArray());
        EasyMock.expect((Object)streamsConfig.defaultKeySerde()).andReturn((Object)Serdes.ByteArray());
        EasyMock.replay((Object[])new Object[]{streamsConfig});
        this.context = new ProcessorContextImpl((TaskId)EasyMock.mock(TaskId.class), (StreamTask)EasyMock.mock(StreamTask.class), streamsConfig, (RecordCollector)EasyMock.mock(RecordCollector.class), (ProcessorStateManager)EasyMock.mock(ProcessorStateManager.class), (StreamsMetricsImpl)EasyMock.mock(StreamsMetricsImpl.class), (ThreadCache)EasyMock.mock(ThreadCache.class));
    }

    @Test
    public void shouldNotAllowToScheduleZeroMillisecondPunctuation() {
        try {
            this.context.schedule(Duration.ofMillis(0L), null, null);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)Matchers.equalTo((Object)"The minimum supported scheduling interval is 1 millisecond."));
        }
    }

    @Test
    public void shouldNotAllowToScheduleSubMillisecondPunctuation() {
        try {
            this.context.schedule(Duration.ofNanos(999999L), null, null);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)Matchers.equalTo((Object)"The minimum supported scheduling interval is 1 millisecond."));
        }
    }
}

