/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.PartitionGroup;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.streams.processor.internals.StampedRecord;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockSourceNode;
import org.apache.kafka.test.MockTimestampExtractor;
import org.junit.Assert;
import org.junit.Test;

public class PartitionGroupTest {
    private final LogContext logContext = new LogContext();
    private final Serializer<Integer> intSerializer = new IntegerSerializer();
    private final Deserializer<Integer> intDeserializer = new IntegerDeserializer();
    private final TimestampExtractor timestampExtractor = new MockTimestampExtractor();
    private final String[] topics = new String[]{"topic"};
    private final TopicPartition partition1 = new TopicPartition(this.topics[0], 1);
    private final TopicPartition partition2 = new TopicPartition(this.topics[0], 2);
    private final RecordQueue queue1 = new RecordQueue(this.partition1, new MockSourceNode<Integer, Integer>(this.topics, this.intDeserializer, this.intDeserializer), this.timestampExtractor, (DeserializationExceptionHandler)new LogAndContinueExceptionHandler(), (InternalProcessorContext)new InternalMockProcessorContext(), this.logContext);
    private final RecordQueue queue2 = new RecordQueue(this.partition2, new MockSourceNode<Integer, Integer>(this.topics, this.intDeserializer, this.intDeserializer), this.timestampExtractor, (DeserializationExceptionHandler)new LogAndContinueExceptionHandler(), (InternalProcessorContext)new InternalMockProcessorContext(), this.logContext);
    private final byte[] recordValue = this.intSerializer.serialize(null, (Object)10);
    private final byte[] recordKey = this.intSerializer.serialize(null, (Object)1);
    private final Metrics metrics = new Metrics();
    private final MetricName lastLatenessValue = new MetricName("record-lateness-last-value", "", "", Utils.mkMap((Map.Entry[])new Map.Entry[0]));
    private final PartitionGroup group = new PartitionGroup(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.partition1, (Object)this.queue1), Utils.mkEntry((Object)this.partition2, (Object)this.queue2)}), PartitionGroupTest.getValueSensor(this.metrics, this.lastLatenessValue));

    private static Sensor getValueSensor(Metrics metrics, MetricName metricName) {
        Sensor lastRecordedValue = metrics.sensor(metricName.name());
        lastRecordedValue.add(metricName, (MeasurableStat)new Value());
        return lastRecordedValue;
    }

    @Test
    public void testTimeTracking() {
        Assert.assertEquals((long)0L, (long)this.group.numBuffered());
        List<ConsumerRecord> list1 = Arrays.asList(new ConsumerRecord("topic", 1, 1L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 3L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 5L, (Object)this.recordKey, (Object)this.recordValue));
        this.group.addRawRecords(this.partition1, list1);
        List<ConsumerRecord> list2 = Arrays.asList(new ConsumerRecord("topic", 2, 2L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 2, 4L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 2, 6L, (Object)this.recordKey, (Object)this.recordValue));
        this.group.addRawRecords(this.partition2, list2);
        this.verifyBuffered(6, 3, 3);
        Assert.assertEquals((long)-1L, (long)this.group.timestamp());
        Assert.assertEquals((Object)0.0, (Object)this.metrics.metric(this.lastLatenessValue).metricValue());
        PartitionGroup.RecordInfo info = new PartitionGroup.RecordInfo();
        StampedRecord record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition1, (Object)info.partition());
        this.verifyTimes(record, 1L, 1L);
        this.verifyBuffered(5, 2, 3);
        Assert.assertEquals((Object)0.0, (Object)this.metrics.metric(this.lastLatenessValue).metricValue());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition2, (Object)info.partition());
        this.verifyTimes(record, 2L, 2L);
        this.verifyBuffered(4, 2, 2);
        Assert.assertEquals((Object)0.0, (Object)this.metrics.metric(this.lastLatenessValue).metricValue());
        List<ConsumerRecord> list3 = Arrays.asList(new ConsumerRecord("topic", 1, 2L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 4L, (Object)this.recordKey, (Object)this.recordValue));
        this.group.addRawRecords(this.partition1, list3);
        this.verifyBuffered(6, 4, 2);
        Assert.assertEquals((long)2L, (long)this.group.timestamp());
        Assert.assertEquals((Object)0.0, (Object)this.metrics.metric(this.lastLatenessValue).metricValue());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition1, (Object)info.partition());
        this.verifyTimes(record, 3L, 3L);
        this.verifyBuffered(5, 3, 2);
        Assert.assertEquals((Object)0.0, (Object)this.metrics.metric(this.lastLatenessValue).metricValue());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition2, (Object)info.partition());
        this.verifyTimes(record, 4L, 4L);
        this.verifyBuffered(4, 3, 1);
        Assert.assertEquals((Object)0.0, (Object)this.metrics.metric(this.lastLatenessValue).metricValue());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition1, (Object)info.partition());
        this.verifyTimes(record, 5L, 5L);
        this.verifyBuffered(3, 2, 1);
        Assert.assertEquals((Object)0.0, (Object)this.metrics.metric(this.lastLatenessValue).metricValue());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition1, (Object)info.partition());
        this.verifyTimes(record, 2L, 5L);
        this.verifyBuffered(2, 1, 1);
        Assert.assertEquals((Object)3.0, (Object)this.metrics.metric(this.lastLatenessValue).metricValue());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition1, (Object)info.partition());
        this.verifyTimes(record, 4L, 5L);
        this.verifyBuffered(1, 0, 1);
        Assert.assertEquals((Object)1.0, (Object)this.metrics.metric(this.lastLatenessValue).metricValue());
        record = this.group.nextRecord(info);
        Assert.assertEquals((Object)this.partition2, (Object)info.partition());
        this.verifyTimes(record, 6L, 6L);
        this.verifyBuffered(0, 0, 0);
        Assert.assertEquals((Object)0.0, (Object)this.metrics.metric(this.lastLatenessValue).metricValue());
    }

    private void verifyTimes(StampedRecord record, long recordTime, long streamTime) {
        Assert.assertEquals((long)recordTime, (long)record.timestamp);
        Assert.assertEquals((long)streamTime, (long)this.group.timestamp());
    }

    private void verifyBuffered(int totalBuffered, int partitionOneBuffered, int partitionTwoBuffered) {
        Assert.assertEquals((long)totalBuffered, (long)this.group.numBuffered());
        Assert.assertEquals((long)partitionOneBuffered, (long)this.group.numBuffered(this.partition1));
        Assert.assertEquals((long)partitionTwoBuffered, (long)this.group.numBuffered(this.partition2));
    }
}

