/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.BatchingStateRestoreCallback;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.internals.CompositeRestoreListener;
import org.apache.kafka.test.MockBatchingStateRestoreListener;
import org.apache.kafka.test.MockStateRestoreListener;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class CompositeRestoreListenerTest {
    private final MockStateRestoreCallback stateRestoreCallback = new MockStateRestoreCallback();
    private final MockBatchingStateRestoreListener batchingStateRestoreCallback = new MockBatchingStateRestoreListener();
    private final MockNoListenBatchingStateRestoreCallback noListenBatchingStateRestoreCallback = new MockNoListenBatchingStateRestoreCallback();
    private final MockStateRestoreListener reportingStoreListener = new MockStateRestoreListener();
    private final byte[] key = "key".getBytes(StandardCharsets.UTF_8);
    private final byte[] value = "value".getBytes(StandardCharsets.UTF_8);
    private final Collection<KeyValue<byte[], byte[]>> records = Collections.singletonList(KeyValue.pair((Object)this.key, (Object)this.value));
    private final Collection<ConsumerRecord<byte[], byte[]>> consumerRecords = Collections.singletonList(new ConsumerRecord("", 0, 0L, (Object)this.key, (Object)this.value));
    private final String storeName = "test_store";
    private final long startOffset = 0L;
    private final long endOffset = 1L;
    private final long batchOffset = 1L;
    private final long numberRestored = 1L;
    private final TopicPartition topicPartition = new TopicPartition("testTopic", 1);
    private CompositeRestoreListener compositeRestoreListener;

    @Test
    public void shouldRestoreInNonBatchMode() {
        this.setUpCompositeRestoreListener(this.stateRestoreCallback);
        this.compositeRestoreListener.restoreBatch(this.consumerRecords);
        Assert.assertThat((Object)this.stateRestoreCallback.restoredKey, (Matcher)Is.is((Object)this.key));
        Assert.assertThat((Object)this.stateRestoreCallback.restoredValue, (Matcher)Is.is((Object)this.value));
    }

    @Test
    public void shouldRestoreInBatchMode() {
        this.setUpCompositeRestoreListener((StateRestoreCallback)this.batchingStateRestoreCallback);
        this.compositeRestoreListener.restoreBatch(this.consumerRecords);
        Assert.assertThat(this.batchingStateRestoreCallback.getRestoredRecords(), (Matcher)Is.is(this.records));
    }

    @Test
    public void shouldNotifyRestoreStartNonBatchMode() {
        this.setUpCompositeRestoreListener(this.stateRestoreCallback);
        this.compositeRestoreListener.onRestoreStart(this.topicPartition, "test_store", 0L, 1L);
        this.assertStateRestoreListenerOnStartNotification(this.stateRestoreCallback);
        this.assertStateRestoreListenerOnStartNotification(this.reportingStoreListener);
    }

    @Test
    public void shouldNotifyRestoreStartBatchMode() {
        this.setUpCompositeRestoreListener((StateRestoreCallback)this.batchingStateRestoreCallback);
        this.compositeRestoreListener.onRestoreStart(this.topicPartition, "test_store", 0L, 1L);
        this.assertStateRestoreListenerOnStartNotification(this.batchingStateRestoreCallback);
        this.assertStateRestoreListenerOnStartNotification(this.reportingStoreListener);
    }

    @Test
    public void shouldNotifyRestoreProgressNonBatchMode() {
        this.setUpCompositeRestoreListener(this.stateRestoreCallback);
        this.compositeRestoreListener.onBatchRestored(this.topicPartition, "test_store", 1L, 1L);
        this.assertStateRestoreListenerOnBatchCompleteNotification(this.stateRestoreCallback);
        this.assertStateRestoreListenerOnBatchCompleteNotification(this.reportingStoreListener);
    }

    @Test
    public void shouldNotifyRestoreProgressBatchMode() {
        this.setUpCompositeRestoreListener((StateRestoreCallback)this.batchingStateRestoreCallback);
        this.compositeRestoreListener.onBatchRestored(this.topicPartition, "test_store", 1L, 1L);
        this.assertStateRestoreListenerOnBatchCompleteNotification(this.batchingStateRestoreCallback);
        this.assertStateRestoreListenerOnBatchCompleteNotification(this.reportingStoreListener);
    }

    @Test
    public void shouldNotifyRestoreEndInNonBatchMode() {
        this.setUpCompositeRestoreListener(this.stateRestoreCallback);
        this.compositeRestoreListener.onRestoreEnd(this.topicPartition, "test_store", 1L);
        this.assertStateRestoreOnEndNotification(this.stateRestoreCallback);
        this.assertStateRestoreOnEndNotification(this.reportingStoreListener);
    }

    @Test
    public void shouldNotifyRestoreEndInBatchMode() {
        this.setUpCompositeRestoreListener((StateRestoreCallback)this.batchingStateRestoreCallback);
        this.compositeRestoreListener.onRestoreEnd(this.topicPartition, "test_store", 1L);
        this.assertStateRestoreOnEndNotification(this.batchingStateRestoreCallback);
        this.assertStateRestoreOnEndNotification(this.reportingStoreListener);
    }

    @Test
    public void shouldHandleNullReportStoreListener() {
        this.compositeRestoreListener = new CompositeRestoreListener((StateRestoreCallback)this.batchingStateRestoreCallback);
        this.compositeRestoreListener.setUserRestoreListener(null);
        this.compositeRestoreListener.restoreBatch(this.consumerRecords);
        this.compositeRestoreListener.onRestoreStart(this.topicPartition, "test_store", 0L, 1L);
        this.compositeRestoreListener.onBatchRestored(this.topicPartition, "test_store", 1L, 1L);
        this.compositeRestoreListener.onRestoreEnd(this.topicPartition, "test_store", 1L);
        Assert.assertThat(this.batchingStateRestoreCallback.getRestoredRecords(), (Matcher)Is.is(this.records));
        this.assertStateRestoreOnEndNotification(this.batchingStateRestoreCallback);
    }

    @Test
    public void shouldHandleNoRestoreListener() {
        this.compositeRestoreListener = new CompositeRestoreListener((StateRestoreCallback)this.noListenBatchingStateRestoreCallback);
        this.compositeRestoreListener.setUserRestoreListener(null);
        this.compositeRestoreListener.restoreBatch(this.consumerRecords);
        this.compositeRestoreListener.onRestoreStart(this.topicPartition, "test_store", 0L, 1L);
        this.compositeRestoreListener.onBatchRestored(this.topicPartition, "test_store", 1L, 1L);
        this.compositeRestoreListener.onRestoreEnd(this.topicPartition, "test_store", 1L);
        Assert.assertThat(this.noListenBatchingStateRestoreCallback.restoredRecords, (Matcher)Is.is(this.records));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowExceptionWhenSinglePutDirectlyCalled() {
        this.compositeRestoreListener = new CompositeRestoreListener((StateRestoreCallback)this.noListenBatchingStateRestoreCallback);
        this.compositeRestoreListener.restore(this.key, this.value);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowExceptionWhenRestoreAllDirectlyCalled() {
        this.compositeRestoreListener = new CompositeRestoreListener((StateRestoreCallback)this.noListenBatchingStateRestoreCallback);
        this.compositeRestoreListener.restoreAll(Collections.emptyList());
    }

    private void assertStateRestoreListenerOnStartNotification(MockStateRestoreListener restoreListener) {
        Assert.assertTrue((boolean)restoreListener.storeNameCalledStates.containsKey("restore_start"));
        Assert.assertThat((Object)restoreListener.restoreTopicPartition, (Matcher)Is.is((Object)this.topicPartition));
        Assert.assertThat((Object)restoreListener.restoreStartOffset, (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)restoreListener.restoreEndOffset, (Matcher)Is.is((Object)1L));
    }

    private void assertStateRestoreListenerOnBatchCompleteNotification(MockStateRestoreListener restoreListener) {
        Assert.assertTrue((boolean)restoreListener.storeNameCalledStates.containsKey("restore_batch"));
        Assert.assertThat((Object)restoreListener.restoreTopicPartition, (Matcher)Is.is((Object)this.topicPartition));
        Assert.assertThat((Object)restoreListener.restoredBatchOffset, (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)restoreListener.numBatchRestored, (Matcher)Is.is((Object)1L));
    }

    private void assertStateRestoreOnEndNotification(MockStateRestoreListener restoreListener) {
        Assert.assertTrue((boolean)restoreListener.storeNameCalledStates.containsKey("restore_end"));
        Assert.assertThat((Object)restoreListener.restoreTopicPartition, (Matcher)Is.is((Object)this.topicPartition));
        Assert.assertThat((Object)restoreListener.totalNumRestored, (Matcher)Is.is((Object)1L));
    }

    private void setUpCompositeRestoreListener(StateRestoreCallback stateRestoreCallback) {
        this.compositeRestoreListener = new CompositeRestoreListener(stateRestoreCallback);
        this.compositeRestoreListener.setUserRestoreListener((StateRestoreListener)this.reportingStoreListener);
    }

    private static class MockNoListenBatchingStateRestoreCallback
    implements BatchingStateRestoreCallback {
        Collection<KeyValue<byte[], byte[]>> restoredRecords;

        private MockNoListenBatchingStateRestoreCallback() {
        }

        public void restoreAll(Collection<KeyValue<byte[], byte[]>> records) {
            this.restoredRecords = records;
        }

        public void restore(byte[] key, byte[] value) {
            throw new IllegalStateException("Should not be called");
        }
    }

    private static class MockStateRestoreCallback
    extends MockStateRestoreListener
    implements StateRestoreCallback {
        byte[] restoredKey;
        byte[] restoredValue;

        private MockStateRestoreCallback() {
        }

        @Override
        public void restore(byte[] key, byte[] value) {
            this.restoredKey = key;
            this.restoredValue = value;
        }
    }
}

