/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.internals.suppress.BufferFullStrategy;
import org.apache.kafka.streams.kstream.internals.suppress.EagerBufferConfigImpl;
import org.apache.kafka.streams.kstream.internals.suppress.FinalResultsSuppressionBuilder;
import org.apache.kafka.streams.kstream.internals.suppress.StrictBufferConfigImpl;
import org.apache.kafka.streams.kstream.internals.suppress.SuppressedInternal;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class SuppressedTest {
    @Test
    public void bufferBuilderShouldBeConsistent() {
        MatcherAssert.assertThat((String)"noBound should remove bounds", (Object)Suppressed.BufferConfig.maxBytes((long)2L).withMaxRecords(4L).withNoBound(), (Matcher)CoreMatchers.is((Object)Suppressed.BufferConfig.unbounded()));
        MatcherAssert.assertThat((String)"keys alone should be set", (Object)Suppressed.BufferConfig.maxRecords((long)2L), (Matcher)CoreMatchers.is((Object)new EagerBufferConfigImpl(2L, Long.MAX_VALUE)));
        MatcherAssert.assertThat((String)"size alone should be set", (Object)Suppressed.BufferConfig.maxBytes((long)2L), (Matcher)CoreMatchers.is((Object)new EagerBufferConfigImpl(Long.MAX_VALUE, 2L)));
    }

    @Test
    public void intermediateEventsShouldAcceptAnyBufferAndSetBounds() {
        MatcherAssert.assertThat((String)"name should be set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded()).withName("myname"), (Matcher)CoreMatchers.is((Object)new SuppressedInternal("myname", Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded(), null, false)));
        MatcherAssert.assertThat((String)"time alone should be set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded()), (Matcher)CoreMatchers.is((Object)new SuppressedInternal(null, Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded(), null, false)));
        MatcherAssert.assertThat((String)"time and unbounded buffer should be set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded()), (Matcher)CoreMatchers.is((Object)new SuppressedInternal(null, Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded(), null, false)));
        MatcherAssert.assertThat((String)"time and keys buffer should be set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.maxRecords((long)2L)), (Matcher)CoreMatchers.is((Object)new SuppressedInternal(null, Duration.ofMillis(2L), Suppressed.BufferConfig.maxRecords((long)2L), null, false)));
        MatcherAssert.assertThat((String)"time and size buffer should be set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.maxBytes((long)2L)), (Matcher)CoreMatchers.is((Object)new SuppressedInternal(null, Duration.ofMillis(2L), Suppressed.BufferConfig.maxBytes((long)2L), null, false)));
        MatcherAssert.assertThat((String)"all constraints should be set", (Object)Suppressed.untilTimeLimit((Duration)Duration.ofMillis(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.maxRecords((long)3L).withMaxBytes(2L)), (Matcher)CoreMatchers.is((Object)new SuppressedInternal(null, Duration.ofMillis(2L), (Suppressed.BufferConfig)new EagerBufferConfigImpl(3L, 2L), null, false)));
    }

    @Test
    public void finalEventsShouldAcceptStrictBuffersAndSetBounds() {
        MatcherAssert.assertThat((Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.unbounded()), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder(null, Suppressed.BufferConfig.unbounded())));
        MatcherAssert.assertThat((Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.maxRecords((long)2L).shutDownWhenFull()), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder(null, (Suppressed.StrictBufferConfig)new StrictBufferConfigImpl(2L, Long.MAX_VALUE, BufferFullStrategy.SHUT_DOWN))));
        MatcherAssert.assertThat((Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.maxBytes((long)2L).shutDownWhenFull()), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder(null, (Suppressed.StrictBufferConfig)new StrictBufferConfigImpl(Long.MAX_VALUE, 2L, BufferFullStrategy.SHUT_DOWN))));
        MatcherAssert.assertThat((Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.unbounded()).withName("name"), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder("name", Suppressed.BufferConfig.unbounded())));
        MatcherAssert.assertThat((Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.maxRecords((long)2L).shutDownWhenFull()).withName("name"), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder("name", (Suppressed.StrictBufferConfig)new StrictBufferConfigImpl(2L, Long.MAX_VALUE, BufferFullStrategy.SHUT_DOWN))));
        MatcherAssert.assertThat((Object)Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.maxBytes((long)2L).shutDownWhenFull()).withName("name"), (Matcher)CoreMatchers.is((Object)new FinalResultsSuppressionBuilder("name", (Suppressed.StrictBufferConfig)new StrictBufferConfigImpl(Long.MAX_VALUE, 2L, BufferFullStrategy.SHUT_DOWN))));
    }
}

