/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.AbstractNotifyingBatchingRestoreCallback;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.internals.RecordBatchingStateRestoreCallback;
import org.apache.kafka.streams.processor.internals.StateRestoreCallbackAdapter;

public class CompositeRestoreListener
implements RecordBatchingStateRestoreCallback,
StateRestoreListener {
    public static final NoOpStateRestoreListener NO_OP_STATE_RESTORE_LISTENER = new NoOpStateRestoreListener();
    private final RecordBatchingStateRestoreCallback internalBatchingRestoreCallback;
    private final StateRestoreListener storeRestoreListener;
    private StateRestoreListener userRestoreListener = NO_OP_STATE_RESTORE_LISTENER;

    CompositeRestoreListener(StateRestoreCallback stateRestoreCallback) {
        this.storeRestoreListener = stateRestoreCallback instanceof StateRestoreListener ? (StateRestoreListener)((Object)stateRestoreCallback) : NO_OP_STATE_RESTORE_LISTENER;
        this.internalBatchingRestoreCallback = StateRestoreCallbackAdapter.adapt(stateRestoreCallback);
    }

    @Override
    public void onRestoreStart(TopicPartition topicPartition, String storeName, long startingOffset, long endingOffset) {
        this.userRestoreListener.onRestoreStart(topicPartition, storeName, startingOffset, endingOffset);
        this.storeRestoreListener.onRestoreStart(topicPartition, storeName, startingOffset, endingOffset);
    }

    @Override
    public void onBatchRestored(TopicPartition topicPartition, String storeName, long batchEndOffset, long numRestored) {
        this.userRestoreListener.onBatchRestored(topicPartition, storeName, batchEndOffset, numRestored);
        this.storeRestoreListener.onBatchRestored(topicPartition, storeName, batchEndOffset, numRestored);
    }

    @Override
    public void onRestoreEnd(TopicPartition topicPartition, String storeName, long totalRestored) {
        this.userRestoreListener.onRestoreEnd(topicPartition, storeName, totalRestored);
        this.storeRestoreListener.onRestoreEnd(topicPartition, storeName, totalRestored);
    }

    @Override
    public void restoreBatch(Collection<ConsumerRecord<byte[], byte[]>> records) {
        this.internalBatchingRestoreCallback.restoreBatch(records);
    }

    void setUserRestoreListener(StateRestoreListener userRestoreListener) {
        if (userRestoreListener != null) {
            this.userRestoreListener = userRestoreListener;
        }
    }

    @Override
    public void restoreAll(Collection<KeyValue<byte[], byte[]>> records) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restore(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("Single restore functionality shouldn't be called directly but through the delegated StateRestoreCallback instance");
    }

    private static final class NoOpStateRestoreListener
    extends AbstractNotifyingBatchingRestoreCallback
    implements RecordBatchingStateRestoreCallback {
        private NoOpStateRestoreListener() {
        }

        @Override
        public void restoreBatch(Collection<ConsumerRecord<byte[], byte[]>> records) {
        }
    }
}

