/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

public class TimeWindowedDeserializer<T>
implements Deserializer<Windowed<T>> {
    private final Long windowSize;
    private boolean isChangelogTopic;
    private Deserializer<T> inner;

    public TimeWindowedDeserializer() {
        this(null, Long.MAX_VALUE);
    }

    public TimeWindowedDeserializer(Deserializer<T> inner) {
        this(inner, Long.MAX_VALUE);
    }

    public TimeWindowedDeserializer(Deserializer<T> inner, long windowSize) {
        this.inner = inner;
        this.windowSize = windowSize;
        this.isChangelogTopic = false;
    }

    public Long getWindowSize() {
        return this.windowSize;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (this.inner == null) {
            String propertyName = isKey ? "default.windowed.key.serde.inner" : "default.windowed.value.serde.inner";
            String value = (String)configs.get(propertyName);
            try {
                this.inner = ((Serde)Serde.class.cast(Utils.newInstance((String)value, Serde.class))).deserializer();
                this.inner.configure(configs, isKey);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(propertyName, (Object)value, "Serde class " + value + " could not be found.");
            }
        }
    }

    public Windowed<T> deserialize(String topic, byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        if (this.isChangelogTopic) {
            return WindowKeySchema.fromStoreKey(data, this.windowSize, this.inner, topic);
        }
        return WindowKeySchema.from(data, this.windowSize, this.inner, topic);
    }

    public void close() {
        this.inner.close();
    }

    public void setIsChangelogTopic(boolean isChangelogTopic) {
        this.isChangelogTopic = isChangelogTopic;
    }

    Deserializer<T> innerDeserializer() {
        return this.inner;
    }
}

