/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Printed;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.Serialized;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.TopicNameExtractor;

@InterfaceStability.Evolving
public interface KStream<K, V> {
    public KStream<K, V> filter(Predicate<? super K, ? super V> var1);

    public KStream<K, V> filterNot(Predicate<? super K, ? super V> var1);

    public <KR> KStream<KR, V> selectKey(KeyValueMapper<? super K, ? super V, ? extends KR> var1);

    public <KR, VR> KStream<KR, VR> map(KeyValueMapper<? super K, ? super V, ? extends KeyValue<? extends KR, ? extends VR>> var1);

    public <VR> KStream<K, VR> mapValues(ValueMapper<? super V, ? extends VR> var1);

    public <VR> KStream<K, VR> mapValues(ValueMapperWithKey<? super K, ? super V, ? extends VR> var1);

    public <KR, VR> KStream<KR, VR> flatMap(KeyValueMapper<? super K, ? super V, ? extends Iterable<? extends KeyValue<? extends KR, ? extends VR>>> var1);

    public <VR> KStream<K, VR> flatMapValues(ValueMapper<? super V, ? extends Iterable<? extends VR>> var1);

    public <VR> KStream<K, VR> flatMapValues(ValueMapperWithKey<? super K, ? super V, ? extends Iterable<? extends VR>> var1);

    public void print(Printed<K, V> var1);

    public void foreach(ForeachAction<? super K, ? super V> var1);

    public KStream<K, V> peek(ForeachAction<? super K, ? super V> var1);

    public KStream<K, V>[] branch(Predicate<? super K, ? super V> ... var1);

    public KStream<K, V> merge(KStream<K, V> var1);

    public KStream<K, V> through(String var1);

    public KStream<K, V> through(String var1, Produced<K, V> var2);

    public void to(String var1);

    public void to(String var1, Produced<K, V> var2);

    public void to(TopicNameExtractor<K, V> var1);

    public void to(TopicNameExtractor<K, V> var1, Produced<K, V> var2);

    public <K1, V1> KStream<K1, V1> transform(TransformerSupplier<? super K, ? super V, KeyValue<K1, V1>> var1, String ... var2);

    public <K1, V1> KStream<K1, V1> flatTransform(TransformerSupplier<? super K, ? super V, Iterable<KeyValue<K1, V1>>> var1, String ... var2);

    public <VR> KStream<K, VR> transformValues(ValueTransformerSupplier<? super V, ? extends VR> var1, String ... var2);

    public <VR> KStream<K, VR> transformValues(ValueTransformerWithKeySupplier<? super K, ? super V, ? extends VR> var1, String ... var2);

    public void process(ProcessorSupplier<? super K, ? super V> var1, String ... var2);

    public KGroupedStream<K, V> groupByKey();

    @Deprecated
    public KGroupedStream<K, V> groupByKey(Serialized<K, V> var1);

    public KGroupedStream<K, V> groupByKey(Grouped<K, V> var1);

    public <KR> KGroupedStream<KR, V> groupBy(KeyValueMapper<? super K, ? super V, KR> var1);

    @Deprecated
    public <KR> KGroupedStream<KR, V> groupBy(KeyValueMapper<? super K, ? super V, KR> var1, Serialized<KR, V> var2);

    public <KR> KGroupedStream<KR, V> groupBy(KeyValueMapper<? super K, ? super V, KR> var1, Grouped<KR, V> var2);

    public <VO, VR> KStream<K, VR> join(KStream<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, JoinWindows var3);

    public <VO, VR> KStream<K, VR> join(KStream<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, JoinWindows var3, Joined<K, V, VO> var4);

    public <VO, VR> KStream<K, VR> leftJoin(KStream<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, JoinWindows var3);

    public <VO, VR> KStream<K, VR> leftJoin(KStream<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, JoinWindows var3, Joined<K, V, VO> var4);

    public <VO, VR> KStream<K, VR> outerJoin(KStream<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, JoinWindows var3);

    public <VO, VR> KStream<K, VR> outerJoin(KStream<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, JoinWindows var3, Joined<K, V, VO> var4);

    public <VT, VR> KStream<K, VR> join(KTable<K, VT> var1, ValueJoiner<? super V, ? super VT, ? extends VR> var2);

    public <VT, VR> KStream<K, VR> join(KTable<K, VT> var1, ValueJoiner<? super V, ? super VT, ? extends VR> var2, Joined<K, V, VT> var3);

    public <VT, VR> KStream<K, VR> leftJoin(KTable<K, VT> var1, ValueJoiner<? super V, ? super VT, ? extends VR> var2);

    public <VT, VR> KStream<K, VR> leftJoin(KTable<K, VT> var1, ValueJoiner<? super V, ? super VT, ? extends VR> var2, Joined<K, V, VT> var3);

    public <GK, GV, RV> KStream<K, RV> join(GlobalKTable<GK, GV> var1, KeyValueMapper<? super K, ? super V, ? extends GK> var2, ValueJoiner<? super V, ? super GV, ? extends RV> var3);

    public <GK, GV, RV> KStream<K, RV> leftJoin(GlobalKTable<GK, GV> var1, KeyValueMapper<? super K, ? super V, ? extends GK> var2, ValueJoiner<? super V, ? super GV, ? extends RV> var3);
}

