/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.MeteredWindowStoreIterator;
import org.apache.kafka.streams.state.internals.MeteredWindowedKeyValueIterator;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class MeteredWindowStore<K, V>
extends WrappedStateStore.AbstractStateStore
implements WindowStore<K, V> {
    private final WindowStore<Bytes, byte[]> inner;
    private final String metricScope;
    private final Time time;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private StreamsMetricsImpl metrics;
    private Sensor putTime;
    private Sensor fetchTime;
    private Sensor flushTime;
    private StateSerdes<K, V> serdes;
    private ProcessorContext context;

    MeteredWindowStore(WindowStore<Bytes, byte[]> inner, String metricScope, Time time, Serde<K> keySerde, Serde<V> valueSerde) {
        super(inner);
        this.inner = inner;
        this.metricScope = metricScope;
        this.time = time;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.context = context;
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name()), (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.valueSerde == null ? context.valueSerde() : this.valueSerde));
        String tagKey = "task-id";
        String taskName = context.taskId().toString();
        this.metrics = (StreamsMetricsImpl)context.metrics();
        this.putTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, this.name(), "put", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        this.fetchTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, this.name(), "fetch", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        this.flushTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, this.name(), "flush", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        Sensor restoreTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, this.name(), "restore", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        long startNs = this.time.nanoseconds();
        try {
            this.inner.init(context, root);
        }
        finally {
            this.metrics.recordLatency(restoreTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, this.context.timestamp());
    }

    @Override
    public void put(K key, V value, long timestamp) {
        long startNs = this.time.nanoseconds();
        try {
            this.inner.put(this.keyBytes(key), this.serdes.rawValue(value), timestamp);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key, value);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
        finally {
            this.metrics.recordLatency(this.putTime, startNs, this.time.nanoseconds());
        }
    }

    private Bytes keyBytes(K key) {
        return Bytes.wrap((byte[])this.serdes.rawKey(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V fetch(K key, long timestamp) {
        long startNs = this.time.nanoseconds();
        try {
            byte[] result = (byte[])this.inner.fetch(this.keyBytes(key), timestamp);
            if (result == null) {
                V v = null;
                return v;
            }
            V v = this.serdes.valueFrom(result);
            return v;
        }
        finally {
            this.metrics.recordLatency(this.fetchTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        return new MeteredWindowStoreIterator<V>(this.inner.fetch(this.keyBytes(key), timeFrom, timeTo), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> all() {
        return new MeteredWindowedKeyValueIterator<K, V>(this.inner.all(), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetchAll(long timeFrom, long timeTo) {
        return new MeteredWindowedKeyValueIterator<K, V>(this.inner.fetchAll(timeFrom, timeTo), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K from, K to, long timeFrom, long timeTo) {
        return new MeteredWindowedKeyValueIterator<K, V>(this.inner.fetch(this.keyBytes(from), this.keyBytes(to), timeFrom, timeTo), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public void flush() {
        long startNs = this.time.nanoseconds();
        try {
            this.inner.flush();
        }
        finally {
            this.metrics.recordLatency(this.flushTime, startNs, this.time.nanoseconds());
        }
    }
}

