/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;

class LRUCacheEntry
extends ProcessorRecordContext {
    private final byte[] value;
    private final long sizeBytes;
    private boolean isDirty;

    LRUCacheEntry(byte[] value) {
        this(value, null, false, -1L, -1L, -1, "");
    }

    LRUCacheEntry(byte[] value, Headers headers, boolean isDirty, long offset, long timestamp, int partition, String topic) {
        super(timestamp, offset, partition, topic, headers);
        this.value = value;
        this.isDirty = isDirty;
        this.sizeBytes = (value == null ? 0 : value.length) + 1 + 8 + 8 + 4 + (topic == null ? 0 : topic.length());
    }

    void markClean() {
        this.isDirty = false;
    }

    boolean isDirty() {
        return this.isDirty;
    }

    long size() {
        return this.sizeBytes;
    }

    byte[] value() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LRUCacheEntry that = (LRUCacheEntry)o;
        return this.timestamp() == that.timestamp() && this.offset() == that.offset() && this.partition() == that.partition() && Objects.equals(this.topic(), that.topic()) && Objects.equals(this.headers(), that.headers()) && Arrays.equals(this.value, that.value()) && this.isDirty == that.isDirty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.timestamp(), this.offset(), this.topic(), this.partition(), this.headers(), this.value, this.isDirty);
    }
}

