/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public abstract class AbstractStream<K> {
    protected final InternalStreamsBuilder builder;
    protected final String name;
    protected final Set<String> sourceNodes;

    public AbstractStream(AbstractStream<K> stream) {
        this.builder = stream.builder;
        this.name = stream.name;
        this.sourceNodes = stream.sourceNodes;
    }

    AbstractStream(InternalStreamsBuilder builder, String name, Set<String> sourceNodes) {
        if (sourceNodes == null || sourceNodes.isEmpty()) {
            throw new IllegalArgumentException("parameter <sourceNodes> must not be null or empty");
        }
        this.builder = builder;
        this.name = name;
        this.sourceNodes = sourceNodes;
    }

    protected InternalTopologyBuilder internalTopologyBuilder() {
        return this.builder.internalTopologyBuilder;
    }

    Set<String> ensureJoinableWith(AbstractStream<K> other) {
        HashSet<String> allSourceNodes = new HashSet<String>();
        allSourceNodes.addAll(this.sourceNodes);
        allSourceNodes.addAll(other.sourceNodes);
        this.builder.internalTopologyBuilder.copartitionSources(allSourceNodes);
        return allSourceNodes;
    }

    static <T2, T1, R> ValueJoiner<T2, T1, R> reverseJoiner(final ValueJoiner<T1, T2, R> joiner) {
        return new ValueJoiner<T2, T1, R>(){

            @Override
            public R apply(T2 value2, T1 value1) {
                return joiner.apply(value1, value2);
            }
        };
    }

    static <K, V, VR> ValueMapperWithKey<K, V, VR> withKey(final ValueMapper<V, VR> valueMapper) {
        Objects.requireNonNull(valueMapper, "valueMapper can't be null");
        return new ValueMapperWithKey<K, V, VR>(){

            @Override
            public VR apply(K readOnlyKey, V value) {
                return valueMapper.apply(value);
            }
        };
    }

    static <K, V, VR> ValueTransformerWithKeySupplier<K, V, VR> toValueTransformerWithKeySupplier(final ValueTransformerSupplier<V, VR> valueTransformerSupplier) {
        Objects.requireNonNull(valueTransformerSupplier, "valueTransformerSupplier can't be null");
        return new ValueTransformerWithKeySupplier<K, V, VR>(){

            @Override
            public ValueTransformerWithKey<K, V, VR> get() {
                final ValueTransformer valueTransformer = valueTransformerSupplier.get();
                return new ValueTransformerWithKey<K, V, VR>(){

                    @Override
                    public void init(ProcessorContext context) {
                        valueTransformer.init(context);
                    }

                    @Override
                    public VR transform(K readOnlyKey, V value) {
                        return valueTransformer.transform(value);
                    }

                    @Override
                    public void close() {
                        valueTransformer.close();
                    }
                };
            }
        };
    }
}

