/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.CachingSessionStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingSessionBytesStore;
import org.apache.kafka.streams.state.internals.MeteredSessionStore;
import org.apache.kafka.streams.state.internals.SessionStoreBuilder;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class SessionStoreBuilderTest {
    @Mock(type=MockType.NICE)
    private SessionBytesStoreSupplier supplier;
    @Mock(type=MockType.NICE)
    private SessionStore<Bytes, byte[]> inner;
    private SessionStoreBuilder<String, String> builder;

    @Before
    public void setUp() throws Exception {
        EasyMock.expect((Object)this.supplier.get()).andReturn(this.inner);
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.replay((Object[])new Object[]{this.supplier});
        this.builder = new SessionStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test
    public void shouldHaveMeteredStoreAsOuterStore() {
        SessionStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredSessionStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreByDefault() {
        SessionStore store = this.builder.build();
        StateStore next = ((WrappedStateStore)store).wrappedStore();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingSessionBytesStore.class));
    }

    @Test
    public void shouldNotHaveChangeLoggingStoreWhenDisabled() {
        SessionStore store = (SessionStore)this.builder.withLoggingDisabled().build();
        StateStore next = ((WrappedStateStore)store).wrappedStore();
        MatcherAssert.assertThat((Object)next, (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldHaveCachingStoreWhenEnabled() {
        SessionStore store = (SessionStore)this.builder.withCachingEnabled().build();
        StateStore wrapped = ((WrappedStateStore)store).wrappedStore();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredSessionStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(CachingSessionStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreWhenLoggingEnabled() {
        SessionStore store = (SessionStore)this.builder.withLoggingEnabled(Collections.emptyMap()).build();
        StateStore wrapped = ((WrappedStateStore)store).wrappedStore();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredSessionStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingSessionBytesStore.class));
        MatcherAssert.assertThat((Object)((WrappedStateStore)wrapped).wrappedStore(), (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldHaveCachingAndChangeLoggingWhenBothEnabled() {
        SessionStore store = (SessionStore)this.builder.withLoggingEnabled(Collections.emptyMap()).withCachingEnabled().build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrappedStore();
        WrappedStateStore changeLogging = (WrappedStateStore)caching.wrappedStore();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredSessionStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingSessionStore.class));
        MatcherAssert.assertThat((Object)changeLogging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingSessionBytesStore.class));
        MatcherAssert.assertThat((Object)changeLogging.wrappedStore(), (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfInnerIsNull() {
        new SessionStoreBuilder(null, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfKeySerdeIsNull() {
        new SessionStoreBuilder(this.supplier, null, Serdes.String(), (Time)new MockTime());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfValueSerdeIsNull() {
        new SessionStoreBuilder(this.supplier, Serdes.String(), null, (Time)new MockTime());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfTimeIsNull() {
        new SessionStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfMetricsScopeIsNull() {
        new SessionStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }
}

