/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.DefaultProductionExceptionHandler;
import org.apache.kafka.streams.errors.ProductionExceptionHandler;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;
import org.apache.kafka.streams.state.internals.SerdeThatDoesntHandleNull;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class RocksDBWindowStoreTest {
    private static final long DEFAULT_CACHE_SIZE_BYTES = 0x100000L;
    private final int numSegments = 3;
    private final long windowSize = 3L;
    private final String windowName = "window";
    private final long segmentSize = 60000L;
    private final long retentionPeriod = 120000L;
    private final Segments segments = new Segments("window", 120000L, 3);
    private final StateSerdes<Integer, String> serdes = new StateSerdes("", Serdes.Integer(), Serdes.String());
    private final List<KeyValue<byte[], byte[]>> changeLog = new ArrayList<KeyValue<byte[], byte[]>>();
    private final ThreadCache cache = new ThreadCache(new LogContext("TestCache "), 0x100000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
    private final Producer<byte[], byte[]> producer = new MockProducer(true, Serdes.ByteArray().serializer(), Serdes.ByteArray().serializer());
    private final RecordCollector recordCollector = new RecordCollectorImpl(this.producer, "RocksDBWindowStoreTestTask", new LogContext("RocksDBWindowStoreTestTask "), (ProductionExceptionHandler)new DefaultProductionExceptionHandler(), new Metrics().sensor("skipped-records")){

        public <K1, V1> void send(String topic, K1 key, V1 value, Headers headers, Integer partition, Long timestamp, Serializer<K1> keySerializer, Serializer<V1> valueSerializer) {
            RocksDBWindowStoreTest.this.changeLog.add(new KeyValue((Object)keySerializer.serialize(topic, key), (Object)valueSerializer.serialize(topic, value)));
        }
    };
    private final File baseDir = TestUtils.tempDirectory((String)"test");
    private final InternalMockProcessorContext context = new InternalMockProcessorContext(this.baseDir, Serdes.ByteArray(), Serdes.ByteArray(), this.recordCollector, this.cache);
    private WindowStore<Integer, String> windowStore;

    private WindowStore<Integer, String> createWindowStore(ProcessorContext context, boolean retainDuplicates) {
        WindowStore store = (WindowStore)Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.persistentWindowStore((String)"window", (long)120000L, (int)3, (long)3L, (boolean)retainDuplicates), (Serde)Serdes.Integer(), (Serde)Serdes.String()).build();
        store.init(context, (StateStore)store);
        return store;
    }

    private WindowStore<Integer, String> createWindowStore(ProcessorContext context) {
        return this.createWindowStore(context, false);
    }

    @After
    public void closeStore() {
        if (this.windowStore != null) {
            this.windowStore.close();
        }
    }

    @Test
    public void shouldOnlyIterateOpenSegments() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        long currentTime = 0L;
        this.context.setRecordContext(this.createRecordContext(currentTime));
        this.windowStore.put((Object)1, (Object)"one");
        this.context.setRecordContext(this.createRecordContext(currentTime += 60000L));
        this.windowStore.put((Object)1, (Object)"two");
        this.context.setRecordContext(this.createRecordContext(currentTime += 60000L));
        this.windowStore.put((Object)1, (Object)"three");
        WindowStoreIterator iterator = this.windowStore.fetch((Object)1, 0L, currentTime);
        this.context.setRecordContext(this.createRecordContext(currentTime += 60000L));
        this.windowStore.put((Object)1, (Object)"four");
        Assert.assertEquals((Object)new KeyValue((Object)60000L, (Object)"two"), (Object)iterator.next());
        Assert.assertEquals((Object)new KeyValue((Object)120000L, (Object)"three"), (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private ProcessorRecordContext createRecordContext(long time) {
        return new ProcessorRecordContext(time, 0L, 0, "topic", null);
    }

    @Test
    public void testRangeAndSinglePointFetch() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        long startTime = 59996L;
        this.putFirstBatch(this.windowStore, 59996L, this.context);
        Assert.assertEquals((Object)"zero", (Object)this.windowStore.fetch((Object)0, 59996L));
        Assert.assertEquals((Object)"one", (Object)this.windowStore.fetch((Object)1, 59997L));
        Assert.assertEquals((Object)"two", (Object)this.windowStore.fetch((Object)2, 59998L));
        Assert.assertEquals((Object)"four", (Object)this.windowStore.fetch((Object)4, 60000L));
        Assert.assertEquals((Object)"five", (Object)this.windowStore.fetch((Object)5, 60001L));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"zero"}), this.toList(this.windowStore.fetch((Object)0, 59993L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"one"}), this.toList(this.windowStore.fetch((Object)1, 59994L, 60000L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two"}), this.toList(this.windowStore.fetch((Object)2, 59995L, 60001L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)3, 59996L, 60002L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"four"}), this.toList(this.windowStore.fetch((Object)4, 59997L, 60003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"five"}), this.toList(this.windowStore.fetch((Object)5, 59998L, 60004L)));
        this.putSecondBatch(this.windowStore, 59996L, this.context);
        Assert.assertEquals((Object)"two+1", (Object)this.windowStore.fetch((Object)2, 59999L));
        Assert.assertEquals((Object)"two+2", (Object)this.windowStore.fetch((Object)2, 60000L));
        Assert.assertEquals((Object)"two+3", (Object)this.windowStore.fetch((Object)2, 60001L));
        Assert.assertEquals((Object)"two+4", (Object)this.windowStore.fetch((Object)2, 60002L));
        Assert.assertEquals((Object)"two+5", (Object)this.windowStore.fetch((Object)2, 60003L));
        Assert.assertEquals((Object)"two+6", (Object)this.windowStore.fetch((Object)2, 60004L));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 59991L, 59997L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two"}), this.toList(this.windowStore.fetch((Object)2, 59992L, 59998L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two", "two+1"}), this.toList(this.windowStore.fetch((Object)2, 59993L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two", "two+1", "two+2"}), this.toList(this.windowStore.fetch((Object)2, 59994L, 60000L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two", "two+1", "two+2", "two+3"}), this.toList(this.windowStore.fetch((Object)2, 59995L, 60001L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two", "two+1", "two+2", "two+3", "two+4"}), this.toList(this.windowStore.fetch((Object)2, 59996L, 60002L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two", "two+1", "two+2", "two+3", "two+4", "two+5"}), this.toList(this.windowStore.fetch((Object)2, 59997L, 60003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two", "two+1", "two+2", "two+3", "two+4", "two+5", "two+6"}), this.toList(this.windowStore.fetch((Object)2, 59998L, 60004L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+1", "two+2", "two+3", "two+4", "two+5", "two+6"}), this.toList(this.windowStore.fetch((Object)2, 59999L, 60005L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+2", "two+3", "two+4", "two+5", "two+6"}), this.toList(this.windowStore.fetch((Object)2, 60000L, 60006L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+3", "two+4", "two+5", "two+6"}), this.toList(this.windowStore.fetch((Object)2, 60001L, 60007L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+4", "two+5", "two+6"}), this.toList(this.windowStore.fetch((Object)2, 60002L, 60008L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+5", "two+6"}), this.toList(this.windowStore.fetch((Object)2, 60003L, 60009L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+6"}), this.toList(this.windowStore.fetch((Object)2, 60004L, 60010L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 60005L, 60011L)));
        this.windowStore.flush();
        Map<Integer, Set<String>> entriesByKey = this.entriesByKey(this.changeLog, 59996L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"zero@0"}), entriesByKey.get(0));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"one@1"}), entriesByKey.get(1));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"two@2", "two+1@3", "two+2@4", "two+3@5", "two+4@6", "two+5@7", "two+6@8"}), entriesByKey.get(2));
        Assert.assertNull(entriesByKey.get(3));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"four@4"}), entriesByKey.get(4));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"five@5"}), entriesByKey.get(5));
        Assert.assertNull(entriesByKey.get(6));
    }

    @Test
    public void shouldGetAll() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        long startTime = 59996L;
        this.putFirstBatch(this.windowStore, 59996L, this.context);
        KeyValue<Windowed<Integer>, String> zero = this.windowedPair(0, "zero", 59996L);
        KeyValue<Windowed<Integer>, String> one = this.windowedPair(1, "one", 59997L);
        KeyValue<Windowed<Integer>, String> two = this.windowedPair(2, "two", 59998L);
        KeyValue<Windowed<Integer>, String> four = this.windowedPair(4, "four", 60000L);
        KeyValue<Windowed<Integer>, String> five = this.windowedPair(5, "five", 60001L);
        Assert.assertEquals((Object)Utils.mkList((Object[])new KeyValue[]{zero, one, two, four, five}), StreamsTestUtils.toList(this.windowStore.all()));
    }

    @Test
    public void shouldFetchAllInTimeRange() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        long startTime = 59996L;
        this.putFirstBatch(this.windowStore, 59996L, this.context);
        KeyValue<Windowed<Integer>, String> zero = this.windowedPair(0, "zero", 59996L);
        KeyValue<Windowed<Integer>, String> one = this.windowedPair(1, "one", 59997L);
        KeyValue<Windowed<Integer>, String> two = this.windowedPair(2, "two", 59998L);
        KeyValue<Windowed<Integer>, String> four = this.windowedPair(4, "four", 60000L);
        KeyValue<Windowed<Integer>, String> five = this.windowedPair(5, "five", 60001L);
        Assert.assertEquals((Object)Utils.mkList((Object[])new KeyValue[]{one, two, four}), StreamsTestUtils.toList(this.windowStore.fetchAll(59997L, 60000L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new KeyValue[]{zero, one, two}), StreamsTestUtils.toList(this.windowStore.fetchAll(59996L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new KeyValue[]{one, two, four, five}), StreamsTestUtils.toList(this.windowStore.fetchAll(59997L, 60001L)));
    }

    @Test
    public void testFetchRange() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        long startTime = 59996L;
        this.putFirstBatch(this.windowStore, 59996L, this.context);
        KeyValue<Windowed<Integer>, String> zero = this.windowedPair(0, "zero", 59996L);
        KeyValue<Windowed<Integer>, String> one = this.windowedPair(1, "one", 59997L);
        KeyValue<Windowed<Integer>, String> two = this.windowedPair(2, "two", 59998L);
        KeyValue<Windowed<Integer>, String> four = this.windowedPair(4, "four", 60000L);
        KeyValue<Windowed<Integer>, String> five = this.windowedPair(5, "five", 60001L);
        Assert.assertEquals((Object)Utils.mkList((Object[])new KeyValue[]{zero, one}), StreamsTestUtils.toList(this.windowStore.fetch((Object)0, (Object)1, 59993L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new KeyValue[]{one}), StreamsTestUtils.toList(this.windowStore.fetch((Object)1, (Object)1, 59993L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new KeyValue[]{one, two}), StreamsTestUtils.toList(this.windowStore.fetch((Object)1, (Object)3, 59993L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new KeyValue[]{zero, one, two}), StreamsTestUtils.toList(this.windowStore.fetch((Object)0, (Object)5, 59993L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new KeyValue[]{zero, one, two, four, five}), StreamsTestUtils.toList(this.windowStore.fetch((Object)0, (Object)5, 59993L, 60004L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new KeyValue[]{two, four, five}), StreamsTestUtils.toList(this.windowStore.fetch((Object)0, (Object)5, 59998L, 60004L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), StreamsTestUtils.toList(this.windowStore.fetch((Object)4, (Object)5, 59998L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), StreamsTestUtils.toList(this.windowStore.fetch((Object)0, (Object)3, 59999L, 60004L)));
    }

    @Test
    public void testPutAndFetchBefore() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        long startTime = 59996L;
        this.putFirstBatch(this.windowStore, 59996L, this.context);
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"zero"}), this.toList(this.windowStore.fetch((Object)0, 59993L, 59996L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"one"}), this.toList(this.windowStore.fetch((Object)1, 59994L, 59997L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two"}), this.toList(this.windowStore.fetch((Object)2, 59995L, 59998L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)3, 59996L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"four"}), this.toList(this.windowStore.fetch((Object)4, 59997L, 60000L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"five"}), this.toList(this.windowStore.fetch((Object)5, 59998L, 60001L)));
        this.putSecondBatch(this.windowStore, 59996L, this.context);
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 59992L, 59995L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 59993L, 59996L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 59994L, 59997L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two"}), this.toList(this.windowStore.fetch((Object)2, 59995L, 59998L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two", "two+1"}), this.toList(this.windowStore.fetch((Object)2, 59996L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two", "two+1", "two+2"}), this.toList(this.windowStore.fetch((Object)2, 59997L, 60000L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two", "two+1", "two+2", "two+3"}), this.toList(this.windowStore.fetch((Object)2, 59998L, 60001L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+1", "two+2", "two+3", "two+4"}), this.toList(this.windowStore.fetch((Object)2, 59999L, 60002L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+2", "two+3", "two+4", "two+5"}), this.toList(this.windowStore.fetch((Object)2, 60000L, 60003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+3", "two+4", "two+5", "two+6"}), this.toList(this.windowStore.fetch((Object)2, 60001L, 60004L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+4", "two+5", "two+6"}), this.toList(this.windowStore.fetch((Object)2, 60002L, 60005L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+5", "two+6"}), this.toList(this.windowStore.fetch((Object)2, 60003L, 60006L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+6"}), this.toList(this.windowStore.fetch((Object)2, 60004L, 60007L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 60005L, 60008L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 60006L, 60009L)));
        this.windowStore.flush();
        Map<Integer, Set<String>> entriesByKey = this.entriesByKey(this.changeLog, 59996L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"zero@0"}), entriesByKey.get(0));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"one@1"}), entriesByKey.get(1));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"two@2", "two+1@3", "two+2@4", "two+3@5", "two+4@6", "two+5@7", "two+6@8"}), entriesByKey.get(2));
        Assert.assertNull(entriesByKey.get(3));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"four@4"}), entriesByKey.get(4));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"five@5"}), entriesByKey.get(5));
        Assert.assertNull(entriesByKey.get(6));
    }

    @Test
    public void testPutAndFetchAfter() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        long startTime = 59996L;
        this.putFirstBatch(this.windowStore, 59996L, this.context);
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"zero"}), this.toList(this.windowStore.fetch((Object)0, 59996L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"one"}), this.toList(this.windowStore.fetch((Object)1, 59997L, 60000L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two"}), this.toList(this.windowStore.fetch((Object)2, 59998L, 60001L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)3, 59999L, 60002L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"four"}), this.toList(this.windowStore.fetch((Object)4, 60000L, 60003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"five"}), this.toList(this.windowStore.fetch((Object)5, 60001L, 60004L)));
        this.putSecondBatch(this.windowStore, 59996L, this.context);
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 59994L, 59997L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two"}), this.toList(this.windowStore.fetch((Object)2, 59995L, 59998L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two", "two+1"}), this.toList(this.windowStore.fetch((Object)2, 59996L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two", "two+1", "two+2"}), this.toList(this.windowStore.fetch((Object)2, 59997L, 60000L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two", "two+1", "two+2", "two+3"}), this.toList(this.windowStore.fetch((Object)2, 59998L, 60001L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+1", "two+2", "two+3", "two+4"}), this.toList(this.windowStore.fetch((Object)2, 59999L, 60002L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+2", "two+3", "two+4", "two+5"}), this.toList(this.windowStore.fetch((Object)2, 60000L, 60003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+3", "two+4", "two+5", "two+6"}), this.toList(this.windowStore.fetch((Object)2, 60001L, 60004L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+4", "two+5", "two+6"}), this.toList(this.windowStore.fetch((Object)2, 60002L, 60005L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+5", "two+6"}), this.toList(this.windowStore.fetch((Object)2, 60003L, 60006L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two+6"}), this.toList(this.windowStore.fetch((Object)2, 60004L, 60007L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 60005L, 60008L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 60006L, 60009L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 60007L, 60010L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 60008L, 60011L)));
        this.windowStore.flush();
        Map<Integer, Set<String>> entriesByKey = this.entriesByKey(this.changeLog, 59996L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"zero@0"}), entriesByKey.get(0));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"one@1"}), entriesByKey.get(1));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"two@2", "two+1@3", "two+2@4", "two+3@5", "two+4@6", "two+5@7", "two+6@8"}), entriesByKey.get(2));
        Assert.assertNull(entriesByKey.get(3));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"four@4"}), entriesByKey.get(4));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"five@5"}), entriesByKey.get(5));
        Assert.assertNull(entriesByKey.get(6));
    }

    @Test
    public void testPutSameKeyTimestamp() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context, true);
        long startTime = 59996L;
        this.context.setRecordContext(this.createRecordContext(59996L));
        this.windowStore.put((Object)0, (Object)"zero");
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"zero"}), this.toList(this.windowStore.fetch((Object)0, 59993L, 59999L)));
        this.windowStore.put((Object)0, (Object)"zero");
        this.windowStore.put((Object)0, (Object)"zero+");
        this.windowStore.put((Object)0, (Object)"zero++");
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"zero", "zero", "zero+", "zero++"}), this.toList(this.windowStore.fetch((Object)0, 59993L, 59999L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"zero", "zero", "zero+", "zero++"}), this.toList(this.windowStore.fetch((Object)0, 59994L, 60000L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"zero", "zero", "zero+", "zero++"}), this.toList(this.windowStore.fetch((Object)0, 59995L, 60001L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"zero", "zero", "zero+", "zero++"}), this.toList(this.windowStore.fetch((Object)0, 59996L, 60002L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)0, 59997L, 60003L)));
        this.windowStore.flush();
        Map<Integer, Set<String>> entriesByKey = this.entriesByKey(this.changeLog, 59996L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"zero@0", "zero@0", "zero+@0", "zero++@0"}), entriesByKey.get(0));
    }

    @Test
    public void testRolling() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        Segments segments = new Segments("window", 120000L, 3);
        long startTime = 120000L;
        long increment = 30000L;
        this.context.setRecordContext(this.createRecordContext(120000L));
        this.windowStore.put((Object)0, (Object)"zero");
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(2L)}), this.segmentDirs(this.baseDir));
        this.context.setRecordContext(this.createRecordContext(150000L));
        this.windowStore.put((Object)1, (Object)"one");
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(2L)}), this.segmentDirs(this.baseDir));
        this.context.setRecordContext(this.createRecordContext(180000L));
        this.windowStore.put((Object)2, (Object)"two");
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(2L), segments.segmentName(3L)}), this.segmentDirs(this.baseDir));
        this.context.setRecordContext(this.createRecordContext(240000L));
        this.windowStore.put((Object)4, (Object)"four");
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(2L), segments.segmentName(3L), segments.segmentName(4L)}), this.segmentDirs(this.baseDir));
        this.context.setRecordContext(this.createRecordContext(270000L));
        this.windowStore.put((Object)5, (Object)"five");
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(2L), segments.segmentName(3L), segments.segmentName(4L)}), this.segmentDirs(this.baseDir));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"zero"}), this.toList(this.windowStore.fetch((Object)0, 119997L, 120003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"one"}), this.toList(this.windowStore.fetch((Object)1, 149997L, 150003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two"}), this.toList(this.windowStore.fetch((Object)2, 179997L, 180003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)3, 209997L, 210003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"four"}), this.toList(this.windowStore.fetch((Object)4, 239997L, 240003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"five"}), this.toList(this.windowStore.fetch((Object)5, 269997L, 270003L)));
        this.context.setRecordContext(this.createRecordContext(300000L));
        this.windowStore.put((Object)6, (Object)"six");
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(3L), segments.segmentName(4L), segments.segmentName(5L)}), this.segmentDirs(this.baseDir));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)0, 119997L, 120003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)1, 149997L, 150003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two"}), this.toList(this.windowStore.fetch((Object)2, 179997L, 180003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)3, 209997L, 210003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"four"}), this.toList(this.windowStore.fetch((Object)4, 239997L, 240003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"five"}), this.toList(this.windowStore.fetch((Object)5, 269997L, 270003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"six"}), this.toList(this.windowStore.fetch((Object)6, 299997L, 300003L)));
        this.context.setRecordContext(this.createRecordContext(330000L));
        this.windowStore.put((Object)7, (Object)"seven");
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(3L), segments.segmentName(4L), segments.segmentName(5L)}), this.segmentDirs(this.baseDir));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)0, 119997L, 120003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)1, 149997L, 150003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"two"}), this.toList(this.windowStore.fetch((Object)2, 179997L, 180003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)3, 209997L, 210003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"four"}), this.toList(this.windowStore.fetch((Object)4, 239997L, 240003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"five"}), this.toList(this.windowStore.fetch((Object)5, 269997L, 270003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"six"}), this.toList(this.windowStore.fetch((Object)6, 299997L, 300003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"seven"}), this.toList(this.windowStore.fetch((Object)7, 329997L, 330003L)));
        this.context.setRecordContext(this.createRecordContext(360000L));
        this.windowStore.put((Object)8, (Object)"eight");
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(4L), segments.segmentName(5L), segments.segmentName(6L)}), this.segmentDirs(this.baseDir));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)0, 119997L, 120003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)1, 149997L, 150003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 179997L, 180003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)3, 209997L, 210003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"four"}), this.toList(this.windowStore.fetch((Object)4, 239997L, 240003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"five"}), this.toList(this.windowStore.fetch((Object)5, 269997L, 270003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"six"}), this.toList(this.windowStore.fetch((Object)6, 299997L, 300003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"seven"}), this.toList(this.windowStore.fetch((Object)7, 329997L, 330003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"eight"}), this.toList(this.windowStore.fetch((Object)8, 359997L, 360003L)));
        this.windowStore.flush();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(4L), segments.segmentName(5L), segments.segmentName(6L)}), this.segmentDirs(this.baseDir));
    }

    @Test
    public void testRestore() throws IOException {
        long startTime = 120000L;
        long increment = 30000L;
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        this.context.setRecordContext(this.createRecordContext(120000L));
        this.windowStore.put((Object)0, (Object)"zero");
        this.context.setRecordContext(this.createRecordContext(150000L));
        this.windowStore.put((Object)1, (Object)"one");
        this.context.setRecordContext(this.createRecordContext(180000L));
        this.windowStore.put((Object)2, (Object)"two");
        this.context.setRecordContext(this.createRecordContext(210000L));
        this.windowStore.put((Object)3, (Object)"three");
        this.context.setRecordContext(this.createRecordContext(240000L));
        this.windowStore.put((Object)4, (Object)"four");
        this.context.setRecordContext(this.createRecordContext(270000L));
        this.windowStore.put((Object)5, (Object)"five");
        this.context.setRecordContext(this.createRecordContext(300000L));
        this.windowStore.put((Object)6, (Object)"six");
        this.context.setRecordContext(this.createRecordContext(330000L));
        this.windowStore.put((Object)7, (Object)"seven");
        this.context.setRecordContext(this.createRecordContext(360000L));
        this.windowStore.put((Object)8, (Object)"eight");
        this.windowStore.flush();
        this.windowStore.close();
        Utils.delete((File)this.baseDir);
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)0, 119997L, 120003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)1, 149997L, 150003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 179997L, 180003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)3, 209997L, 210003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)4, 239997L, 240003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)5, 269997L, 270003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)6, 299997L, 300003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)7, 329997L, 330003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)8, 359997L, 360003L)));
        this.context.restore("window", this.changeLog);
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)0, 119997L, 120003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)1, 149997L, 150003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)2, 179997L, 180003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new Object[0]), this.toList(this.windowStore.fetch((Object)3, 209997L, 210003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"four"}), this.toList(this.windowStore.fetch((Object)4, 239997L, 240003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"five"}), this.toList(this.windowStore.fetch((Object)5, 269997L, 270003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"six"}), this.toList(this.windowStore.fetch((Object)6, 299997L, 300003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"seven"}), this.toList(this.windowStore.fetch((Object)7, 329997L, 330003L)));
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"eight"}), this.toList(this.windowStore.fetch((Object)8, 359997L, 360003L)));
        this.windowStore.flush();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(4L), this.segments.segmentName(5L), this.segments.segmentName(6L)}), this.segmentDirs(this.baseDir));
    }

    @Test
    public void testSegmentMaintenance() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context, true);
        this.context.setTime(0L);
        this.context.setRecordContext(this.createRecordContext(0L));
        this.windowStore.put((Object)0, (Object)"v");
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(0L)}), this.segmentDirs(this.baseDir));
        this.context.setRecordContext(this.createRecordContext(59999L));
        this.windowStore.put((Object)0, (Object)"v");
        this.windowStore.put((Object)0, (Object)"v");
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(0L)}), this.segmentDirs(this.baseDir));
        this.context.setRecordContext(this.createRecordContext(60000L));
        this.windowStore.put((Object)0, (Object)"v");
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(0L), this.segments.segmentName(1L)}), this.segmentDirs(this.baseDir));
        WindowStoreIterator iter = this.windowStore.fetch((Object)0, 0L, 240000L);
        int fetchedCount = 0;
        while (iter.hasNext()) {
            iter.next();
            ++fetchedCount;
        }
        Assert.assertEquals((long)4L, (long)fetchedCount);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(0L), this.segments.segmentName(1L)}), this.segmentDirs(this.baseDir));
        this.context.setRecordContext(this.createRecordContext(180000L));
        this.windowStore.put((Object)0, (Object)"v");
        iter = this.windowStore.fetch((Object)0, 0L, 240000L);
        fetchedCount = 0;
        while (iter.hasNext()) {
            iter.next();
            ++fetchedCount;
        }
        Assert.assertEquals((long)2L, (long)fetchedCount);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(1L), this.segments.segmentName(3L)}), this.segmentDirs(this.baseDir));
        this.context.setRecordContext(this.createRecordContext(300000L));
        this.windowStore.put((Object)0, (Object)"v");
        iter = this.windowStore.fetch((Object)0, 240000L, 1000000L);
        fetchedCount = 0;
        while (iter.hasNext()) {
            iter.next();
            ++fetchedCount;
        }
        Assert.assertEquals((long)1L, (long)fetchedCount);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(3L), this.segments.segmentName(5L)}), this.segmentDirs(this.baseDir));
    }

    @Test
    public void testInitialLoading() {
        File storeDir = new File(this.baseDir, "window");
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        new File(storeDir, this.segments.segmentName(0L)).mkdir();
        new File(storeDir, this.segments.segmentName(1L)).mkdir();
        new File(storeDir, this.segments.segmentName(2L)).mkdir();
        new File(storeDir, this.segments.segmentName(3L)).mkdir();
        new File(storeDir, this.segments.segmentName(4L)).mkdir();
        new File(storeDir, this.segments.segmentName(5L)).mkdir();
        new File(storeDir, this.segments.segmentName(6L)).mkdir();
        this.windowStore.close();
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(4L), this.segments.segmentName(5L), this.segments.segmentName(6L)}), this.segmentDirs(this.baseDir));
        try (WindowStoreIterator iter = this.windowStore.fetch((Object)0, 0L, 1000000L);){
            while (iter.hasNext()) {
                iter.next();
            }
        }
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{this.segments.segmentName(4L), this.segments.segmentName(5L), this.segments.segmentName(6L)}), this.segmentDirs(this.baseDir));
    }

    @Test
    public void shouldCloseOpenIteratorsWhenStoreIsClosedAndNotThrowInvalidStateStoreExceptionOnHasNext() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        this.context.setRecordContext(this.createRecordContext(0L));
        this.windowStore.put((Object)1, (Object)"one", 1L);
        this.windowStore.put((Object)1, (Object)"two", 2L);
        this.windowStore.put((Object)1, (Object)"three", 3L);
        WindowStoreIterator iterator = this.windowStore.fetch((Object)1, 1L, 3L);
        Assert.assertTrue((boolean)iterator.hasNext());
        this.windowStore.close();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldFetchAndIterateOverExactKeys() {
        long windowSize = 0x7A00000000000000L;
        long retentionPeriod = 0x7A00000000000000L;
        WindowStore windowStore = (WindowStore)Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.persistentWindowStore((String)"window", (long)0x7A00000000000000L, (int)2, (long)0x7A00000000000000L, (boolean)true), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        windowStore.init((ProcessorContext)this.context, (StateStore)windowStore);
        windowStore.put((Object)"a", (Object)"0001", 0L);
        windowStore.put((Object)"aa", (Object)"0002", 0L);
        windowStore.put((Object)"a", (Object)"0003", 1L);
        windowStore.put((Object)"aa", (Object)"0004", 1L);
        windowStore.put((Object)"a", (Object)"0005", 0x79FFFFFFFFFFFFFFL);
        List expected = Utils.mkList((Object[])new String[]{"0001", "0003", "0005"});
        MatcherAssert.assertThat(this.toList(windowStore.fetch((Object)"a", 0L, Long.MAX_VALUE)), (Matcher)CoreMatchers.equalTo((Object)expected));
        List list = StreamsTestUtils.toList(windowStore.fetch((Object)"a", (Object)"a", 0L, Long.MAX_VALUE));
        MatcherAssert.assertThat(list, (Matcher)CoreMatchers.equalTo((Object)Utils.mkList((Object[])new KeyValue[]{RocksDBWindowStoreTest.windowedPair("a", "0001", 0L, 0x7A00000000000000L), RocksDBWindowStoreTest.windowedPair("a", "0003", 1L, 0x7A00000000000000L), RocksDBWindowStoreTest.windowedPair("a", "0005", 0x79FFFFFFFFFFFFFFL, 0x7A00000000000000L)})));
        list = StreamsTestUtils.toList(windowStore.fetch((Object)"aa", (Object)"aa", 0L, Long.MAX_VALUE));
        MatcherAssert.assertThat(list, (Matcher)CoreMatchers.equalTo((Object)Utils.mkList((Object[])new KeyValue[]{RocksDBWindowStoreTest.windowedPair("aa", "0002", 0L, 0x7A00000000000000L), RocksDBWindowStoreTest.windowedPair("aa", "0004", 1L, 0x7A00000000000000L)})));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnPutNullKey() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        this.windowStore.put(null, (Object)"anyValue");
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutNullValue() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        this.windowStore.put((Object)1, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnGetNullKey() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        this.windowStore.fetch(null, 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRangeNullFromKey() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        this.windowStore.fetch(null, (Object)2, 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRangeNullToKey() {
        this.windowStore = this.createWindowStore((ProcessorContext)this.context);
        this.windowStore.fetch((Object)1, null, 1L, 2L);
    }

    @Test
    public void shouldNoNullPointerWhenSerdeDoesNotHandleNull() {
        this.windowStore = new RocksDBWindowStore((SegmentedBytesStore)new RocksDBSegmentedBytesStore("window", 120000L, 3, (SegmentedBytesStore.KeySchema)new WindowKeySchema()), Serdes.Integer(), (Serde)new SerdeThatDoesntHandleNull(), false, 3L);
        this.windowStore.init((ProcessorContext)this.context, this.windowStore);
        Assert.assertNull((Object)this.windowStore.fetch((Object)1, 0L));
    }

    @Test
    public void shouldFetchAndIterateOverExactBinaryKeys() {
        WindowStore windowStore = (WindowStore)Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.persistentWindowStore((String)"window", (long)60000L, (int)2, (long)60000L, (boolean)true), (Serde)Serdes.Bytes(), (Serde)Serdes.String()).build();
        windowStore.init((ProcessorContext)this.context, (StateStore)windowStore);
        Bytes key1 = Bytes.wrap((byte[])new byte[]{0});
        Bytes key2 = Bytes.wrap((byte[])new byte[]{0, 0});
        Bytes key3 = Bytes.wrap((byte[])new byte[]{0, 0, 0});
        windowStore.put((Object)key1, (Object)"1", 0L);
        windowStore.put((Object)key2, (Object)"2", 0L);
        windowStore.put((Object)key3, (Object)"3", 0L);
        windowStore.put((Object)key1, (Object)"4", 1L);
        windowStore.put((Object)key2, (Object)"5", 1L);
        windowStore.put((Object)key3, (Object)"6", 59999L);
        windowStore.put((Object)key1, (Object)"7", 59999L);
        windowStore.put((Object)key2, (Object)"8", 59999L);
        windowStore.put((Object)key3, (Object)"9", 59999L);
        List expectedKey1 = Utils.mkList((Object[])new String[]{"1", "4", "7"});
        MatcherAssert.assertThat(this.toList(windowStore.fetch((Object)key1, 0L, Long.MAX_VALUE)), (Matcher)CoreMatchers.equalTo((Object)expectedKey1));
        List expectedKey2 = Utils.mkList((Object[])new String[]{"2", "5", "8"});
        MatcherAssert.assertThat(this.toList(windowStore.fetch((Object)key2, 0L, Long.MAX_VALUE)), (Matcher)CoreMatchers.equalTo((Object)expectedKey2));
        List expectedKey3 = Utils.mkList((Object[])new String[]{"3", "6", "9"});
        MatcherAssert.assertThat(this.toList(windowStore.fetch((Object)key3, 0L, Long.MAX_VALUE)), (Matcher)CoreMatchers.equalTo((Object)expectedKey3));
    }

    private void putFirstBatch(WindowStore<Integer, String> store, long startTime, InternalMockProcessorContext context) {
        context.setRecordContext(this.createRecordContext(startTime));
        store.put((Object)0, (Object)"zero");
        context.setRecordContext(this.createRecordContext(startTime + 1L));
        store.put((Object)1, (Object)"one");
        context.setRecordContext(this.createRecordContext(startTime + 2L));
        store.put((Object)2, (Object)"two");
        context.setRecordContext(this.createRecordContext(startTime + 4L));
        store.put((Object)4, (Object)"four");
        context.setRecordContext(this.createRecordContext(startTime + 5L));
        store.put((Object)5, (Object)"five");
    }

    private void putSecondBatch(WindowStore<Integer, String> store, long startTime, InternalMockProcessorContext context) {
        context.setRecordContext(this.createRecordContext(startTime + 3L));
        store.put((Object)2, (Object)"two+1");
        context.setRecordContext(this.createRecordContext(startTime + 4L));
        store.put((Object)2, (Object)"two+2");
        context.setRecordContext(this.createRecordContext(startTime + 5L));
        store.put((Object)2, (Object)"two+3");
        context.setRecordContext(this.createRecordContext(startTime + 6L));
        store.put((Object)2, (Object)"two+4");
        context.setRecordContext(this.createRecordContext(startTime + 7L));
        store.put((Object)2, (Object)"two+5");
        context.setRecordContext(this.createRecordContext(startTime + 8L));
        store.put((Object)2, (Object)"two+6");
    }

    private <E> List<E> toList(WindowStoreIterator<E> iterator) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (iterator.hasNext()) {
            list.add(((KeyValue)iterator.next()).value);
        }
        return list;
    }

    private Set<String> segmentDirs(File baseDir) {
        File windowDir = new File(baseDir, "window");
        return new HashSet<Object>(Arrays.asList((Object[])Objects.requireNonNull(windowDir.list())));
    }

    private Map<Integer, Set<String>> entriesByKey(List<KeyValue<byte[], byte[]>> changeLog, long startTime) {
        HashMap<Integer, Set<String>> entriesByKey = new HashMap<Integer, Set<String>>();
        for (KeyValue<byte[], byte[]> entry : changeLog) {
            long timestamp = WindowKeySchema.extractStoreTimestamp((byte[])((byte[])entry.key));
            Integer key = (Integer)WindowKeySchema.extractStoreKey((byte[])((byte[])entry.key), this.serdes);
            String value = entry.value == null ? null : (String)this.serdes.valueFrom((byte[])entry.value);
            Set<String> entries = entriesByKey.get(key);
            if (entries == null) {
                entries = new HashSet<String>();
                entriesByKey.put(key, entries);
            }
            entries.add(value + "@" + (timestamp - startTime));
        }
        return entriesByKey;
    }

    private <K, V> KeyValue<Windowed<K>, V> windowedPair(K key, V value, long timestamp) {
        return RocksDBWindowStoreTest.windowedPair(key, value, timestamp, 3L);
    }

    private static <K, V> KeyValue<Windowed<K>, V> windowedPair(K key, V value, long timestamp, long windowSize) {
        return KeyValue.pair((Object)new Windowed(key, (Window)WindowKeySchema.timeWindowForSize((long)timestamp, (long)windowSize)), value);
    }
}

