/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.MeteredWindowStore;
import org.apache.kafka.streams.state.internals.SerdeThatDoesntHandleNull;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MeteredWindowStoreTest {
    private InternalMockProcessorContext context;
    private final WindowStore<Bytes, byte[]> innerStoreMock = (WindowStore)EasyMock.createNiceMock(WindowStore.class);
    private final MeteredWindowStore<String, String> store = new MeteredWindowStore(this.innerStoreMock, "scope", (Time)new MockTime(), Serdes.String(), (Serde)new SerdeThatDoesntHandleNull());

    public MeteredWindowStoreTest() {
        EasyMock.expect((Object)this.innerStoreMock.name()).andReturn((Object)"mocked-store").anyTimes();
    }

    @Before
    public void setUp() {
        Metrics metrics = new Metrics(new MetricConfig().recordLevel(Sensor.RecordingLevel.DEBUG));
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, "test");
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), streamsMetrics, new StreamsConfig((Map)StreamsTestUtils.minimalStreamsConfig()), new RecordCollector.Supplier(){

            public RecordCollector recordCollector() {
                return new NoOpRecordCollector();
            }
        }, new ThreadCache(new LogContext("testCache "), 0L, streamsMetrics));
    }

    @Test
    public void shouldRecordRestoreLatencyOnInit() {
        this.innerStoreMock.init((ProcessorContext)this.context, this.store);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((ProcessorContext)this.context, this.store);
        Map metrics = this.context.metrics().metrics();
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "restore-total", "stream-scope-metrics", Collections.singletonMap("scope-id", "all")).metricValue());
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "restore-total", "stream-scope-metrics", Collections.singletonMap("scope-id", "mocked-store")).metricValue());
    }

    @Test
    public void shouldRecordPutLatency() {
        byte[] bytes = "a".getBytes();
        this.innerStoreMock.put(EasyMock.eq((Object)Bytes.wrap((byte[])bytes)), EasyMock.anyObject(), EasyMock.eq((long)this.context.timestamp()));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((ProcessorContext)this.context, this.store);
        this.store.put((Object)"a", (Object)"a");
        Map metrics = this.context.metrics().metrics();
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "put-total", "stream-scope-metrics", Collections.singletonMap("scope-id", "all")).metricValue());
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "put-total", "stream-scope-metrics", Collections.singletonMap("scope-id", "mocked-store")).metricValue());
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    @Test
    public void shouldRecordFetchLatency() {
        EasyMock.expect((Object)this.innerStoreMock.fetch((Object)Bytes.wrap((byte[])"a".getBytes()), 1L, 1L)).andReturn((Object)KeyValueIterators.emptyWindowStoreIterator());
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((ProcessorContext)this.context, this.store);
        this.store.fetch((Object)"a", 1L, 1L).close();
        Map metrics = this.context.metrics().metrics();
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "fetch-total", "stream-scope-metrics", Collections.singletonMap("scope-id", "all")).metricValue());
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "fetch-total", "stream-scope-metrics", Collections.singletonMap("scope-id", "mocked-store")).metricValue());
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    @Test
    public void shouldRecordFetchRangeLatency() {
        EasyMock.expect((Object)this.innerStoreMock.fetch((Object)Bytes.wrap((byte[])"a".getBytes()), (Object)Bytes.wrap((byte[])"b".getBytes()), 1L, 1L)).andReturn((Object)KeyValueIterators.emptyIterator());
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((ProcessorContext)this.context, this.store);
        this.store.fetch((Object)"a", (Object)"b", 1L, 1L).close();
        Map metrics = this.context.metrics().metrics();
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "fetch-total", "stream-scope-metrics", Collections.singletonMap("scope-id", "all")).metricValue());
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "fetch-total", "stream-scope-metrics", Collections.singletonMap("scope-id", "mocked-store")).metricValue());
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    @Test
    public void shouldRecordFlushLatency() {
        this.innerStoreMock.flush();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((ProcessorContext)this.context, this.store);
        this.store.flush();
        Map metrics = this.context.metrics().metrics();
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "flush-total", "stream-scope-metrics", Collections.singletonMap("scope-id", "all")).metricValue());
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "flush-total", "stream-scope-metrics", Collections.singletonMap("scope-id", "mocked-store")).metricValue());
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    @Test
    public void shouldCloseUnderlyingStore() {
        this.innerStoreMock.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((ProcessorContext)this.context, this.store);
        this.store.close();
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    @Test
    public void shouldNotExceptionIfFetchReturnsNull() {
        EasyMock.expect((Object)this.innerStoreMock.fetch((Object)Bytes.wrap((byte[])"a".getBytes()), 0L)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((ProcessorContext)this.context, this.store);
        Assert.assertNull((Object)this.store.fetch((Object)"a", 0L));
    }
}

