/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.junit.Assert;
import org.junit.Test;

public class StreamsMetricsImplTest {
    @Test(expected=NullPointerException.class)
    public void testNullMetrics() {
        new StreamsMetricsImpl(null, "");
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveNullSensor() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "");
        streamsMetrics.removeSensor(null);
    }

    @Test
    public void testRemoveSensor() {
        String sensorName = "sensor1";
        String taskName = "task";
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "");
        Sensor sensor1 = streamsMetrics.addSensor("sensor1", Sensor.RecordingLevel.DEBUG);
        streamsMetrics.removeSensor(sensor1);
        Sensor sensor1a = streamsMetrics.addSensor("sensor1", Sensor.RecordingLevel.DEBUG, new Sensor[]{sensor1});
        streamsMetrics.removeSensor(sensor1a);
        Sensor sensor2 = streamsMetrics.addLatencyAndThroughputSensor("task", "scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        streamsMetrics.removeSensor(sensor2);
        Sensor sensor3 = streamsMetrics.addThroughputSensor("task", "scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        streamsMetrics.removeSensor(sensor3);
    }

    @Test
    public void testLatencyMetrics() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "");
        int defaultMetrics = streamsMetrics.metrics().size();
        String taskName = "task";
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        Sensor sensor1 = streamsMetrics.addLatencyAndThroughputSensor("task", "scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        int meterMetricsCount = 2;
        int otherMetricsCount = 4;
        Assert.assertEquals((long)(defaultMetrics + 4 + 4), (long)streamsMetrics.metrics().size());
        streamsMetrics.removeSensor(sensor1);
        Assert.assertEquals((long)defaultMetrics, (long)streamsMetrics.metrics().size());
    }

    @Test
    public void testThroughputMetrics() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "");
        int defaultMetrics = streamsMetrics.metrics().size();
        String taskName = "task";
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        Sensor sensor1 = streamsMetrics.addThroughputSensor("task", "scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        int meterMetricsCount = 2;
        Assert.assertEquals((long)(defaultMetrics + 4), (long)streamsMetrics.metrics().size());
        streamsMetrics.removeSensor(sensor1);
        Assert.assertEquals((long)defaultMetrics, (long)streamsMetrics.metrics().size());
    }
}

