/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.processor.internals.RecordDeserializer;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.junit.Assert;
import org.junit.Test;

public class RecordDeserializerTest {
    private final RecordHeaders headers = new RecordHeaders(new Header[]{new RecordHeader("key", "value".getBytes())});
    private final ConsumerRecord<byte[], byte[]> rawRecord = new ConsumerRecord("topic", 1, 1L, 10L, TimestampType.LOG_APPEND_TIME, Long.valueOf(5L), 3, 5, (Object)new byte[0], (Object)new byte[0], (Headers)this.headers);

    @Test
    public void shouldReturnConsumerRecordWithDeserializedValueWhenNoExceptions() {
        RecordDeserializer recordDeserializer = new RecordDeserializer((SourceNode)new TheSourceNode(false, false, "key", "value"), null, new LogContext(), new Metrics().sensor("skipped-records"));
        ConsumerRecord record = recordDeserializer.deserialize(null, this.rawRecord);
        Assert.assertEquals((Object)this.rawRecord.topic(), (Object)record.topic());
        Assert.assertEquals((long)this.rawRecord.partition(), (long)record.partition());
        Assert.assertEquals((long)this.rawRecord.offset(), (long)record.offset());
        Assert.assertEquals((long)this.rawRecord.checksum(), (long)record.checksum());
        Assert.assertEquals((Object)"key", (Object)record.key());
        Assert.assertEquals((Object)"value", (Object)record.value());
        Assert.assertEquals((long)this.rawRecord.timestamp(), (long)record.timestamp());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)record.timestampType());
        Assert.assertEquals((Object)this.rawRecord.headers(), (Object)record.headers());
    }

    static class TheSourceNode
    extends SourceNode<Object, Object> {
        private final boolean keyThrowsException;
        private final boolean valueThrowsException;
        private final Object key;
        private final Object value;

        TheSourceNode(boolean keyThrowsException, boolean valueThrowsException, Object key, Object value) {
            super("", Collections.emptyList(), null, null);
            this.keyThrowsException = keyThrowsException;
            this.valueThrowsException = valueThrowsException;
            this.key = key;
            this.value = value;
        }

        public Object deserializeKey(String topic, Headers headers, byte[] data) {
            if (this.keyThrowsException) {
                throw new RuntimeException();
            }
            return this.key;
        }

        public Object deserializeValue(String topic, Headers headers, byte[] data) {
            if (this.valueThrowsException) {
                throw new RuntimeException();
            }
            return this.value;
        }
    }
}

