/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.streams.processor.TaskMetadata;

public class ThreadMetadata {
    private final String threadName;
    private final String threadState;
    private final Set<TaskMetadata> activeTasks;
    private final Set<TaskMetadata> standbyTasks;

    public ThreadMetadata(String threadName, String threadState, Set<TaskMetadata> activeTasks, Set<TaskMetadata> standbyTasks) {
        this.threadName = threadName;
        this.threadState = threadState;
        this.activeTasks = Collections.unmodifiableSet(activeTasks);
        this.standbyTasks = Collections.unmodifiableSet(standbyTasks);
    }

    public String threadState() {
        return this.threadState;
    }

    public String threadName() {
        return this.threadName;
    }

    public Set<TaskMetadata> activeTasks() {
        return this.activeTasks;
    }

    public Set<TaskMetadata> standbyTasks() {
        return this.standbyTasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadMetadata that = (ThreadMetadata)o;
        return Objects.equals(this.threadName, that.threadName) && Objects.equals(this.threadState, that.threadState) && Objects.equals(this.activeTasks, that.activeTasks) && Objects.equals(this.standbyTasks, that.standbyTasks);
    }

    public int hashCode() {
        return Objects.hash(this.threadName, this.threadState, this.activeTasks, this.standbyTasks);
    }

    public String toString() {
        return "ThreadMetadata{threadName=" + this.threadName + ", threadState=" + this.threadState + ", activeTasks=" + this.activeTasks + ", standbyTasks=" + this.standbyTasks + '}';
    }
}

