/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kafka.streams.errors.TaskIdFormatException;

public class TaskId
implements Comparable<TaskId> {
    public final int topicGroupId;
    public final int partition;

    public TaskId(int topicGroupId, int partition) {
        this.topicGroupId = topicGroupId;
        this.partition = partition;
    }

    public String toString() {
        return this.topicGroupId + "_" + this.partition;
    }

    public static TaskId parse(String string) {
        int index = string.indexOf(95);
        if (index <= 0 || index + 1 >= string.length()) {
            throw new TaskIdFormatException(string);
        }
        try {
            int topicGroupId = Integer.parseInt(string.substring(0, index));
            int partition = Integer.parseInt(string.substring(index + 1));
            return new TaskId(topicGroupId, partition);
        }
        catch (Exception e) {
            throw new TaskIdFormatException(string);
        }
    }

    public void writeTo(DataOutputStream out) throws IOException {
        out.writeInt(this.topicGroupId);
        out.writeInt(this.partition);
    }

    public static TaskId readFrom(DataInputStream in) throws IOException {
        return new TaskId(in.readInt(), in.readInt());
    }

    public void writeTo(ByteBuffer buf) {
        buf.putInt(this.topicGroupId);
        buf.putInt(this.partition);
    }

    public static TaskId readFrom(ByteBuffer buf) {
        return new TaskId(buf.getInt(), buf.getInt());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TaskId) {
            TaskId other = (TaskId)o;
            return other.topicGroupId == this.topicGroupId && other.partition == this.partition;
        }
        return false;
    }

    public int hashCode() {
        long n = (long)this.topicGroupId << 32 | (long)this.partition;
        return (int)(n % 0xFFFFFFFFL);
    }

    @Override
    public int compareTo(TaskId other) {
        return this.topicGroupId < other.topicGroupId ? -1 : (this.topicGroupId > other.topicGroupId ? 1 : (this.partition < other.partition ? -1 : (this.partition > other.partition ? 1 : 0)));
    }
}

