/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;

class KTableKTableJoinMerger<K, V>
implements KTableProcessorSupplier<K, V, V> {
    private final KTableImpl<K, ?, V> parent1;
    private final KTableImpl<K, ?, V> parent2;
    private final String queryableName;
    private boolean sendOldValues = false;

    KTableKTableJoinMerger(KTableImpl<K, ?, V> parent1, KTableImpl<K, ?, V> parent2, String queryableName) {
        this.parent1 = parent1;
        this.parent2 = parent2;
        this.queryableName = queryableName;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableKTableJoinMergeProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        if (this.queryableName != null) {
            return new KTableMaterializedValueGetterSupplier(this.queryableName);
        }
        return new KTableValueGetterSupplier<K, V>(){

            @Override
            public KTableValueGetter<K, V> get() {
                return KTableKTableJoinMerger.this.parent1.valueGetterSupplier().get();
            }

            @Override
            public String[] storeNames() {
                String storeName;
                int i$;
                String[] storeNames1 = KTableKTableJoinMerger.this.parent1.valueGetterSupplier().storeNames();
                String[] storeNames2 = KTableKTableJoinMerger.this.parent2.valueGetterSupplier().storeNames();
                String[] stores = new String[storeNames1.length + storeNames2.length];
                int i = 0;
                String[] arr$ = storeNames1;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    stores[i] = storeName = arr$[i$];
                    ++i;
                }
                arr$ = storeNames2;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    stores[i] = storeName = arr$[i$];
                    ++i;
                }
                return stores;
            }
        };
    }

    @Override
    public void enableSendingOldValues() {
        this.parent1.enableSendingOldValues();
        this.parent2.enableSendingOldValues();
        this.sendOldValues = true;
    }

    private class KTableKTableJoinMergeProcessor
    extends AbstractProcessor<K, Change<V>> {
        private KeyValueStore<K, V> store;
        private TupleForwarder<K, V> tupleForwarder;

        private KTableKTableJoinMergeProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            if (KTableKTableJoinMerger.this.queryableName != null) {
                this.store = (KeyValueStore)context.getStateStore(KTableKTableJoinMerger.this.queryableName);
                this.tupleForwarder = new TupleForwarder(this.store, context, new ForwardingCacheFlushListener(context, KTableKTableJoinMerger.this.sendOldValues), KTableKTableJoinMerger.this.sendOldValues);
            }
        }

        @Override
        public void process(K key, Change<V> value) {
            if (KTableKTableJoinMerger.this.queryableName != null) {
                this.store.put(key, value.newValue);
                this.tupleForwarder.maybeForward(key, value.newValue, value.oldValue);
            } else {
                this.context().forward(key, value);
            }
        }
    }
}

