/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.StreamsKafkaClient;

public class MockInternalTopicManager
extends InternalTopicManager {
    public Map<String, Integer> readyTopics = new HashMap<String, Integer>();
    private MockConsumer<byte[], byte[]> restoreConsumer;

    public MockInternalTopicManager(StreamsConfig streamsConfig, MockConsumer<byte[], byte[]> restoreConsumer) {
        super(new StreamsKafkaClient(streamsConfig), 0, 0L, (Time)new MockTime());
        this.restoreConsumer = restoreConsumer;
    }

    public void makeReady(Map<InternalTopicConfig, Integer> topics) {
        for (Map.Entry<InternalTopicConfig, Integer> entry : topics.entrySet()) {
            this.readyTopics.put(entry.getKey().name(), entry.getValue());
            ArrayList<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
            for (int i = 0; i < entry.getValue(); ++i) {
                partitions.add(new PartitionInfo(entry.getKey().name(), i, null, null, null));
            }
            this.restoreConsumer.updatePartitions(entry.getKey().name(), partitions);
        }
    }

    public Map<String, Integer> getNumPartitions(Set<String> topics) {
        HashMap<String, Integer> partitions = new HashMap<String, Integer>();
        for (String topic : topics) {
            partitions.put(topic, this.restoreConsumer.partitionsFor(topic) == null ? null : Integer.valueOf(this.restoreConsumer.partitionsFor(topic).size()));
        }
        return partitions;
    }
}

