/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.io.File;
import org.apache.kafka.streams.tests.EosTestClient;
import org.apache.kafka.streams.tests.EosTestDriver;

public class StreamsEosTest {
    public static void main(String[] args) throws Exception {
        String kafka = args[0];
        String stateDir = args.length > 1 ? args[1] : null;
        String command = args.length > 2 ? args[2] : null;
        System.out.println("StreamsTest instance started");
        System.out.println("kafka=" + kafka);
        System.out.println("stateDir=" + stateDir);
        System.out.println("command=" + command);
        if (command == null || stateDir == null) {
            System.exit(-1);
        }
        switch (command) {
            case "run": {
                EosTestDriver.generate(kafka);
                break;
            }
            case "process": {
                new EosTestClient(kafka, new File(stateDir), false).start();
                break;
            }
            case "process-complex": {
                new EosTestClient(kafka, new File(stateDir), true).start();
                break;
            }
            case "verify": {
                EosTestDriver.verify(kafka, false);
                break;
            }
            case "verify-complex": {
                EosTestDriver.verify(kafka, true);
                break;
            }
            default: {
                System.out.println("unknown command: " + command);
            }
        }
    }
}

