/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.test.TestUtils;

public class BrokerCompatibilityTest {
    private static final String SOURCE_TOPIC = "brokerCompatibilitySourceTopic";
    private static final String SINK_TOPIC = "brokerCompatibilitySinkTopic";

    public static void main(String[] args) throws Exception {
        System.out.println("StreamsTest instance started");
        String kafka = args.length > 0 ? args[0] : "localhost:9092";
        String stateDirStr = args.length > 1 ? args[1] : TestUtils.tempDirectory().getAbsolutePath();
        boolean eosEnabled = args.length > 2 ? Boolean.parseBoolean(args[2]) : false;
        File stateDir = new File(stateDirStr);
        stateDir.mkdir();
        Properties streamsProperties = new Properties();
        streamsProperties.put("bootstrap.servers", kafka);
        streamsProperties.put("application.id", "kafka-streams-system-test-broker-compatibility");
        streamsProperties.put("state.dir", stateDir.toString());
        streamsProperties.put("auto.offset.reset", "earliest");
        streamsProperties.put("default.key.serde", Serdes.String().getClass());
        streamsProperties.put("default.value.serde", Serdes.String().getClass());
        streamsProperties.put("commit.interval.ms", (Object)100);
        if (eosEnabled) {
            streamsProperties.put("processing.guarantee", "exactly_once");
        }
        int timeout = 6000;
        streamsProperties.put(StreamsConfig.consumerPrefix((String)"session.timeout.ms"), (Object)6000);
        streamsProperties.put(StreamsConfig.consumerPrefix((String)"fetch.max.wait.ms"), (Object)6000);
        streamsProperties.put("request.timeout.ms", (Object)6001);
        KStreamBuilder builder = new KStreamBuilder();
        builder.stream(new String[]{SOURCE_TOPIC}).to(SINK_TOPIC);
        final KafkaStreams streams = new KafkaStreams((TopologyBuilder)builder, streamsProperties);
        streams.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                System.out.println("FATAL: An unexpected exception is encountered on thread " + t + ": " + e);
                streams.close(30L, TimeUnit.SECONDS);
            }
        });
        System.out.println("start Kafka Streams");
        streams.start();
        System.out.println("send data");
        Properties producerProperties = new Properties();
        producerProperties.put("bootstrap.servers", kafka);
        producerProperties.put("key.serializer", StringSerializer.class);
        producerProperties.put("value.serializer", StringSerializer.class);
        KafkaProducer producer = new KafkaProducer(producerProperties);
        producer.send(new ProducerRecord(SOURCE_TOPIC, (Object)"key", (Object)"value"));
        System.out.println("wait for result");
        BrokerCompatibilityTest.loopUntilRecordReceived(kafka, eosEnabled);
        System.out.println("close Kafka Streams");
        streams.close();
    }

    private static void loopUntilRecordReceived(String kafka, boolean eosEnabled) {
        Properties consumerProperties = new Properties();
        consumerProperties.put("bootstrap.servers", kafka);
        consumerProperties.put("group.id", "broker-compatibility-consumer");
        consumerProperties.put("auto.offset.reset", "earliest");
        consumerProperties.put("key.deserializer", StringDeserializer.class);
        consumerProperties.put("value.deserializer", StringDeserializer.class);
        if (eosEnabled) {
            consumerProperties.put("isolation.level", IsolationLevel.READ_COMMITTED.name().toLowerCase(Locale.ROOT));
        }
        KafkaConsumer consumer = new KafkaConsumer(consumerProperties);
        consumer.subscribe(Collections.singletonList(SINK_TOPIC));
        block0: while (true) {
            ConsumerRecord record;
            ConsumerRecords records = consumer.poll(100L);
            Iterator i$ = records.iterator();
            do {
                if (!i$.hasNext()) continue block0;
            } while (!((String)(record = (ConsumerRecord)i$.next()).key()).equals("key") || !((String)record.value()).equals("value"));
            break;
        }
        consumer.close();
    }
}

