/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.NoOpWindowStore;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.internals.StateStoreTestUtils;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.StateStoreProviderStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WrappingStoreProviderTest {
    private WrappingStoreProvider wrappingStoreProvider;

    @Before
    public void before() {
        StateStoreProviderStub stubProviderOne = new StateStoreProviderStub(false);
        StateStoreProviderStub stubProviderTwo = new StateStoreProviderStub(false);
        stubProviderOne.addStore("kv", (StateStore)StateStoreTestUtils.newKeyValueStore("kv", "app-id", String.class, String.class));
        stubProviderOne.addStore("window", new NoOpWindowStore());
        stubProviderTwo.addStore("kv", (StateStore)StateStoreTestUtils.newKeyValueStore("kv", "app-id", String.class, String.class));
        stubProviderTwo.addStore("window", new NoOpWindowStore());
        this.wrappingStoreProvider = new WrappingStoreProvider(Arrays.asList(stubProviderOne, stubProviderTwo));
    }

    @Test
    public void shouldFindKeyValueStores() throws Exception {
        List results = this.wrappingStoreProvider.stores("kv", QueryableStoreTypes.keyValueStore());
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void shouldFindWindowStores() throws Exception {
        List windowStores = this.wrappingStoreProvider.stores("window", QueryableStoreTypes.windowStore());
        Assert.assertEquals((long)2L, (long)windowStores.size());
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStoreExceptionIfNoStoreOfTypeFound() throws Exception {
        this.wrappingStoreProvider.stores("doesn't exist", QueryableStoreTypes.keyValueStore());
    }
}

