/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Test;

public class WindowKeySchemaTest {
    private final WindowKeySchema windowKeySchema = new WindowKeySchema();

    @Test
    public void testUpperBoundWithLargeTimestamps() throws Exception {
        Bytes upper = this.windowKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(WindowStoreUtils.toBinaryKey((byte[])new byte[]{10}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, 11}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{10}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testUpperBoundWithKeyBytesLargerThanFirstTimestampByte() throws Exception {
        Bytes upper = this.windowKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, -113, -97}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, -113}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, -113, -97}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testUpperBoundWithKeyBytesLargerAndSmallerThanFirstTimestampByte() throws Exception {
        Bytes upper = this.windowKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{12, 12, 9}), 0xAFFFFFFFFFFFFFFL);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(WindowStoreUtils.toBinaryKey((byte[])new byte[]{12, 12}, (long)0xAFFFFFFFFFFFFFFL, (int)Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{12, 12}, (long)0xAFFFFFFFFFFFFFFL, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testUpperBoundWithZeroTimestamp() throws Exception {
        Bytes upper = this.windowKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, 11, 12}, (long)0L, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testLowerBoundWithZeroTimestamp() throws Exception {
        Bytes lower = this.windowKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, 11, 12}, (long)0L, (int)0)));
    }

    @Test
    public void testLowerBoundWithMonZeroTimestamp() throws Exception {
        Bytes lower = this.windowKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 42L);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, 11, 12}, (long)0L, (int)0)));
    }

    @Test
    public void testLowerBoundMatchesTrailingZeros() throws Exception {
        Bytes lower = this.windowKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0x7FFFFFFFFFFFFFFEL);
        MatcherAssert.assertThat((String)"appending zeros to key should still be in range", (lower.compareTo(WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (long)0x7FFFFFFFFFFFFFFEL, (int)0)) < 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, 11, 12}, (long)0L, (int)0)));
    }
}

