/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelegatingPeekingKeyValueIteratorTest {
    private final String name = "name";
    private InMemoryKeyValueStore<String, String> store;

    @Before
    public void setUp() throws Exception {
        this.store = new InMemoryKeyValueStore("name", Serdes.String(), Serdes.String());
    }

    @Test
    public void shouldPeekNextKey() throws Exception {
        this.store.put((Object)"A", (Object)"A");
        DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());
        Assert.assertEquals((Object)"A", (Object)peekingIterator.peekNextKey());
        Assert.assertEquals((Object)"A", (Object)peekingIterator.peekNextKey());
        Assert.assertTrue((boolean)peekingIterator.hasNext());
    }

    @Test
    public void shouldPeekNext() throws Exception {
        this.store.put((Object)"A", (Object)"A");
        DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());
        Assert.assertEquals((Object)KeyValue.pair((Object)"A", (Object)"A"), (Object)peekingIterator.peekNext());
        Assert.assertEquals((Object)KeyValue.pair((Object)"A", (Object)"A"), (Object)peekingIterator.peekNext());
        Assert.assertTrue((boolean)peekingIterator.hasNext());
    }

    @Test
    public void shouldPeekAndIterate() throws Exception {
        String[] kvs;
        for (String kv : kvs = new String[]{"a", "b", "c", "d", "e", "f"}) {
            this.store.put((Object)kv, (Object)kv);
        }
        DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());
        int index = 0;
        while (peekingIterator.hasNext()) {
            String peekNext = (String)peekingIterator.peekNextKey();
            String key = (String)peekingIterator.next().key;
            Assert.assertEquals((Object)kvs[index], (Object)peekNext);
            Assert.assertEquals((Object)kvs[index], (Object)key);
            ++index;
        }
        Assert.assertEquals((long)kvs.length, (long)index);
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowNoSuchElementWhenNoMoreItemsLeftAndNextCalled() throws Exception {
        DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());
        peekingIterator.next();
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowNoSuchElementWhenNoMoreItemsLeftAndPeekNextCalled() throws Exception {
        DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());
        peekingIterator.peekNextKey();
    }
}

