/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.junit.Assert;
import org.junit.Test;

public class StoresTest {
    @Test
    public void shouldCreateInMemoryStoreSupplierWithLoggedConfig() throws Exception {
        StateStoreSupplier supplier = Stores.create((String)"store").withKeys(Serdes.String()).withValues(Serdes.String()).inMemory().enableLogging(Collections.singletonMap("retention.ms", "1000")).build();
        Map config = supplier.logConfig();
        Assert.assertTrue((boolean)supplier.loggingEnabled());
        Assert.assertEquals((Object)"1000", config.get("retention.ms"));
    }

    @Test
    public void shouldCreateInMemoryStoreSupplierNotLogged() throws Exception {
        StateStoreSupplier supplier = Stores.create((String)"store").withKeys(Serdes.String()).withValues(Serdes.String()).inMemory().disableLogging().build();
        Assert.assertFalse((boolean)supplier.loggingEnabled());
    }

    @Test
    public void shouldCreatePersistenStoreSupplierWithLoggedConfig() throws Exception {
        StateStoreSupplier supplier = Stores.create((String)"store").withKeys(Serdes.String()).withValues(Serdes.String()).persistent().enableLogging(Collections.singletonMap("retention.ms", "1000")).build();
        Map config = supplier.logConfig();
        Assert.assertTrue((boolean)supplier.loggingEnabled());
        Assert.assertEquals((Object)"1000", config.get("retention.ms"));
    }

    @Test
    public void shouldCreatePersistenStoreSupplierNotLogged() throws Exception {
        StateStoreSupplier supplier = Stores.create((String)"store").withKeys(Serdes.String()).withValues(Serdes.String()).persistent().disableLogging().build();
        Assert.assertFalse((boolean)supplier.loggingEnabled());
    }
}

