/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.internals.StateRestorer;
import org.apache.kafka.test.MockRestoreCallback;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class StateRestorerTest {
    private static final long OFFSET_LIMIT = 50L;
    private final MockRestoreCallback callback = new MockRestoreCallback();
    private final StateRestorer restorer = new StateRestorer(new TopicPartition("topic", 1), (StateRestoreCallback)this.callback, null, 50L, true);

    @Test
    public void shouldCallRestoreOnRestoreCallback() throws Exception {
        this.restorer.restore(new byte[0], new byte[0]);
        MatcherAssert.assertThat((Object)this.callback.restored.size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldBeCompletedIfRecordOffsetGreaterThanEndOffset() throws Exception {
        Assert.assertTrue((boolean)this.restorer.hasCompleted(11L, 10L));
    }

    @Test
    public void shouldBeCompletedIfRecordOffsetGreaterThanOffsetLimit() throws Exception {
        Assert.assertTrue((boolean)this.restorer.hasCompleted(51L, 100L));
    }

    @Test
    public void shouldBeCompletedIfEndOffsetAndRecordOffsetAreZero() throws Exception {
        Assert.assertTrue((boolean)this.restorer.hasCompleted(0L, 0L));
    }

    @Test
    public void shouldBeCompletedIfOffsetAndOffsetLimitAreZero() throws Exception {
        StateRestorer restorer = new StateRestorer(new TopicPartition("topic", 1), (StateRestoreCallback)this.callback, null, 0L, true);
        Assert.assertTrue((boolean)restorer.hasCompleted(0L, 10L));
    }

    @Test
    public void shouldSetRestoredOffsetToMinOfLimitAndOffset() throws Exception {
        this.restorer.setRestoredOffset(20L);
        MatcherAssert.assertThat((Object)this.restorer.restoredOffset(), (Matcher)CoreMatchers.equalTo((Object)20L));
        this.restorer.setRestoredOffset(100L);
        MatcherAssert.assertThat((Object)this.restorer.restoredOffset(), (Matcher)CoreMatchers.equalTo((Object)50L));
    }

    @Test
    public void shouldSetStartingOffsetToMinOfLimitAndOffset() throws Exception {
        this.restorer.setStartingOffset(20L);
        MatcherAssert.assertThat((Object)this.restorer.startingOffset(), (Matcher)CoreMatchers.equalTo((Object)20L));
        this.restorer.setRestoredOffset(100L);
        MatcherAssert.assertThat((Object)this.restorer.restoredOffset(), (Matcher)CoreMatchers.equalTo((Object)50L));
    }

    @Test
    public void shouldReturnCorrectNumRestoredRecords() throws Exception {
        this.restorer.setStartingOffset(20L);
        this.restorer.setRestoredOffset(40L);
        MatcherAssert.assertThat((Object)this.restorer.restoredNumRecords(), (Matcher)CoreMatchers.equalTo((Object)20L));
        this.restorer.setRestoredOffset(100L);
        MatcherAssert.assertThat((Object)this.restorer.restoredNumRecords(), (Matcher)CoreMatchers.equalTo((Object)30L));
    }
}

