/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StandbyContextImpl;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StoreChangelogReader;
import org.apache.kafka.streams.state.internals.OffsetCheckpoint;
import org.apache.kafka.test.MockRestoreConsumer;
import org.apache.kafka.test.MockStateStoreSupplier;
import org.apache.kafka.test.MockTimestampExtractor;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StandbyTaskTest {
    private final TaskId taskId = new TaskId(0, 1);
    private final Serializer<Integer> intSerializer = new IntegerSerializer();
    private final String applicationId = "test-application";
    private final String storeName1 = "store1";
    private final String storeName2 = "store2";
    private final String storeChangelogTopicName1 = ProcessorStateManager.storeChangelogTopic((String)"test-application", (String)"store1");
    private final String storeChangelogTopicName2 = ProcessorStateManager.storeChangelogTopic((String)"test-application", (String)"store2");
    private final TopicPartition partition1 = new TopicPartition(this.storeChangelogTopicName1, 1);
    private final TopicPartition partition2 = new TopicPartition(this.storeChangelogTopicName2, 1);
    private final Set<TopicPartition> topicPartitions = Collections.emptySet();
    private final ProcessorTopology topology = new ProcessorTopology(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Utils.mkList((Object[])new StateStore[]{new MockStateStoreSupplier("store1", false).get(), new MockStateStoreSupplier("store2", true).get()}), (Map)new HashMap<String, String>(){
        {
            this.put("store1", StandbyTaskTest.this.storeChangelogTopicName1);
            this.put("store2", StandbyTaskTest.this.storeChangelogTopicName2);
        }
    }, Collections.emptyList());
    private final TopicPartition ktable = new TopicPartition("ktable1", 0);
    private final Set<TopicPartition> ktablePartitions = Utils.mkSet((Object[])new TopicPartition[]{this.ktable});
    private final ProcessorTopology ktableTopology = new ProcessorTopology(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Utils.mkList((Object[])new StateStore[]{new MockStateStoreSupplier(this.ktable.topic(), true, false).get()}), (Map)new HashMap<String, String>(){
        {
            this.put("ktable1", StandbyTaskTest.this.ktable.topic());
        }
    }, Collections.emptyList());
    private File baseDir;
    private StateDirectory stateDirectory;
    private final MockConsumer<byte[], byte[]> consumer = new MockConsumer(OffsetResetStrategy.EARLIEST);
    private final MockRestoreConsumer restoreStateConsumer = new MockRestoreConsumer();
    private final StoreChangelogReader changelogReader = new StoreChangelogReader((Consumer)this.restoreStateConsumer);
    private final byte[] recordValue = this.intSerializer.serialize(null, (Object)10);
    private final byte[] recordKey = this.intSerializer.serialize(null, (Object)1);

    private StreamsConfig createConfig(final File baseDir) throws Exception {
        return new StreamsConfig((Map)new Properties(){
            {
                this.setProperty("application.id", "test-application");
                this.setProperty("bootstrap.servers", "localhost:2171");
                this.setProperty("buffered.records.per.partition", "3");
                this.setProperty("state.dir", baseDir.getCanonicalPath());
                this.setProperty("default.timestamp.extractor", MockTimestampExtractor.class.getName());
            }
        });
    }

    @Before
    public void setup() {
        this.restoreStateConsumer.reset();
        this.restoreStateConsumer.updatePartitions(this.storeChangelogTopicName1, Utils.mkList((Object[])new PartitionInfo[]{new PartitionInfo(this.storeChangelogTopicName1, 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.storeChangelogTopicName1, 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.storeChangelogTopicName1, 2, Node.noNode(), new Node[0], new Node[0])}));
        this.restoreStateConsumer.updatePartitions(this.storeChangelogTopicName2, Utils.mkList((Object[])new PartitionInfo[]{new PartitionInfo(this.storeChangelogTopicName2, 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.storeChangelogTopicName2, 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.storeChangelogTopicName2, 2, Node.noNode(), new Node[0], new Node[0])}));
        this.baseDir = TestUtils.tempDirectory();
        this.stateDirectory = new StateDirectory("test-application", this.baseDir.getPath(), (Time)new MockTime());
    }

    @After
    public void cleanup() throws IOException {
        Utils.delete((File)this.baseDir);
    }

    @Test
    public void testStorePartitions() throws Exception {
        StreamsConfig config = this.createConfig(this.baseDir);
        StandbyTask task = new StandbyTask(this.taskId, "test-application", this.topicPartitions, this.topology, this.consumer, (ChangelogReader)this.changelogReader, config, null, this.stateDirectory);
        task.initialize();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{this.partition2}), new HashSet(task.checkpointedOffsets().keySet()));
    }

    @Test(expected=Exception.class)
    public void testUpdateNonPersistentStore() throws Exception {
        StreamsConfig config = this.createConfig(this.baseDir);
        StandbyTask task = new StandbyTask(this.taskId, "test-application", this.topicPartitions, this.topology, this.consumer, (ChangelogReader)this.changelogReader, config, null, this.stateDirectory);
        this.restoreStateConsumer.assign(new ArrayList<TopicPartition>(task.checkpointedOffsets().keySet()));
        task.update(this.partition1, this.records(new ConsumerRecord(this.partition1.topic(), this.partition1.partition(), 10L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)this.recordKey, (Object)this.recordValue)));
    }

    @Test
    public void testUpdate() throws Exception {
        StreamsConfig config = this.createConfig(this.baseDir);
        StandbyTask task = new StandbyTask(this.taskId, "test-application", this.topicPartitions, this.topology, this.consumer, (ChangelogReader)this.changelogReader, config, null, this.stateDirectory);
        task.initialize();
        this.restoreStateConsumer.assign(new ArrayList<TopicPartition>(task.checkpointedOffsets().keySet()));
        for (ConsumerRecord consumerRecord : Arrays.asList(new ConsumerRecord(this.partition2.topic(), this.partition2.partition(), 10L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)1, (Object)100), new ConsumerRecord(this.partition2.topic(), this.partition2.partition(), 20L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)2, (Object)100), new ConsumerRecord(this.partition2.topic(), this.partition2.partition(), 30L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)3, (Object)100))) {
            this.restoreStateConsumer.bufferRecord((ConsumerRecord<Integer, Integer>)consumerRecord);
        }
        for (Map.Entry entry : task.checkpointedOffsets().entrySet()) {
            TopicPartition partition = (TopicPartition)entry.getKey();
            long offset = (Long)entry.getValue();
            if (offset >= 0L) {
                this.restoreStateConsumer.seek(partition, offset);
                continue;
            }
            this.restoreStateConsumer.seekToBeginning(Collections.singleton(partition));
        }
        task.update(this.partition2, this.restoreStateConsumer.poll(100L).records(this.partition2));
        StandbyContextImpl context = (StandbyContextImpl)task.context();
        MockStateStoreSupplier.MockStateStore mockStateStore = (MockStateStoreSupplier.MockStateStore)context.getStateMgr().getStore("store1");
        MockStateStoreSupplier.MockStateStore store2 = (MockStateStoreSupplier.MockStateStore)context.getStateMgr().getStore("store2");
        Assert.assertEquals(Collections.emptyList(), mockStateStore.keys);
        Assert.assertEquals((Object)Utils.mkList((Object[])new Integer[]{1, 2, 3}), store2.keys);
        task.closeStateManager(true);
        File taskDir = this.stateDirectory.directoryForTask(this.taskId);
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(new File(taskDir, ".checkpoint"));
        Map offsets = checkpoint.read();
        Assert.assertEquals((long)1L, (long)offsets.size());
        Assert.assertEquals((Object)new Long(31L), offsets.get(this.partition2));
    }

    @Test
    public void testUpdateKTable() throws Exception {
        this.consumer.assign((Collection)Utils.mkList((Object[])new TopicPartition[]{this.ktable}));
        HashMap<TopicPartition, OffsetAndMetadata> committedOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        committedOffsets.put(new TopicPartition(this.ktable.topic(), this.ktable.partition()), new OffsetAndMetadata(0L));
        this.consumer.commitSync(committedOffsets);
        this.restoreStateConsumer.updatePartitions("ktable1", Utils.mkList((Object[])new PartitionInfo[]{new PartitionInfo("ktable1", 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("ktable1", 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("ktable1", 2, Node.noNode(), new Node[0], new Node[0])}));
        StreamsConfig config = this.createConfig(this.baseDir);
        StandbyTask task = new StandbyTask(this.taskId, "test-application", this.ktablePartitions, this.ktableTopology, this.consumer, (ChangelogReader)this.changelogReader, config, null, this.stateDirectory);
        task.initializeStateStores();
        this.restoreStateConsumer.assign(new ArrayList<TopicPartition>(task.checkpointedOffsets().keySet()));
        for (ConsumerRecord consumerRecord : Arrays.asList(new ConsumerRecord(this.ktable.topic(), this.ktable.partition(), 10L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)1, (Object)100), new ConsumerRecord(this.ktable.topic(), this.ktable.partition(), 20L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)2, (Object)100), new ConsumerRecord(this.ktable.topic(), this.ktable.partition(), 30L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)3, (Object)100), new ConsumerRecord(this.ktable.topic(), this.ktable.partition(), 40L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)4, (Object)100), new ConsumerRecord(this.ktable.topic(), this.ktable.partition(), 50L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)5, (Object)100))) {
            this.restoreStateConsumer.bufferRecord((ConsumerRecord<Integer, Integer>)consumerRecord);
        }
        for (Map.Entry entry : task.checkpointedOffsets().entrySet()) {
            TopicPartition partition = (TopicPartition)entry.getKey();
            long offset = (Long)entry.getValue();
            if (offset >= 0L) {
                this.restoreStateConsumer.seek(partition, offset);
                continue;
            }
            this.restoreStateConsumer.seekToBeginning(Collections.singleton(partition));
        }
        List remaining = task.update(this.ktable, this.restoreStateConsumer.poll(100L).records(this.ktable));
        Assert.assertEquals((long)5L, (long)remaining.size());
        committedOffsets.put(new TopicPartition(this.ktable.topic(), this.ktable.partition()), new OffsetAndMetadata(10L));
        this.consumer.commitSync(committedOffsets);
        task.commit();
        remaining = task.update(this.ktable, remaining);
        Assert.assertEquals((long)5L, (long)remaining.size());
        committedOffsets.put(new TopicPartition(this.ktable.topic(), this.ktable.partition()), new OffsetAndMetadata(11L));
        this.consumer.commitSync(committedOffsets);
        task.commit();
        remaining = task.update(this.ktable, remaining);
        Assert.assertEquals((long)4L, (long)remaining.size());
        committedOffsets.put(new TopicPartition(this.ktable.topic(), this.ktable.partition()), new OffsetAndMetadata(45L));
        this.consumer.commitSync(committedOffsets);
        task.commit();
        remaining = task.update(this.ktable, remaining);
        Assert.assertEquals((long)1L, (long)remaining.size());
        committedOffsets.put(new TopicPartition(this.ktable.topic(), this.ktable.partition()), new OffsetAndMetadata(50L));
        this.consumer.commitSync(committedOffsets);
        task.commit();
        remaining = task.update(this.ktable, remaining);
        Assert.assertEquals((long)1L, (long)remaining.size());
        committedOffsets.put(new TopicPartition(this.ktable.topic(), this.ktable.partition()), new OffsetAndMetadata(60L));
        this.consumer.commitSync(committedOffsets);
        task.commit();
        remaining = task.update(this.ktable, remaining);
        Assert.assertNull((Object)remaining);
        task.closeStateManager(true);
        File file = this.stateDirectory.directoryForTask(this.taskId);
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(new File(file, ".checkpoint"));
        Map offsets = checkpoint.read();
        Assert.assertEquals((long)1L, (long)offsets.size());
        Assert.assertEquals((Object)new Long(51L), offsets.get(this.ktable));
    }

    @Test
    public void shouldNotThrowUnsupportedOperationExceptionWhenInitializingStateStores() throws Exception {
        String changelogName = "test-application-my-store-changelog";
        List partitions = Utils.mkList((Object[])new TopicPartition[]{new TopicPartition("test-application-my-store-changelog", 0)});
        this.consumer.assign((Collection)partitions);
        HashMap<TopicPartition, OffsetAndMetadata> committedOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        committedOffsets.put(new TopicPartition("test-application-my-store-changelog", 0), new OffsetAndMetadata(0L));
        this.consumer.commitSync(committedOffsets);
        this.restoreStateConsumer.updatePartitions("test-application-my-store-changelog", Utils.mkList((Object[])new PartitionInfo[]{new PartitionInfo("test-application-my-store-changelog", 0, Node.noNode(), new Node[0], new Node[0])}));
        KStreamBuilder builder = new KStreamBuilder();
        builder.stream(new String[]{"topic"}).groupByKey().count("my-store");
        ProcessorTopology topology = builder.setApplicationId("test-application").build(Integer.valueOf(0));
        StreamsConfig config = this.createConfig(this.baseDir);
        new StandbyTask(this.taskId, "test-application", (Collection)partitions, topology, this.consumer, (ChangelogReader)this.changelogReader, config, (StreamsMetrics)new MockStreamsMetrics(new Metrics()), this.stateDirectory);
    }

    @Test
    public void shouldCheckpointStoreOffsetsOnCommit() throws Exception {
        this.consumer.assign((Collection)Utils.mkList((Object[])new TopicPartition[]{this.ktable}));
        HashMap<TopicPartition, OffsetAndMetadata> committedOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        committedOffsets.put(new TopicPartition(this.ktable.topic(), this.ktable.partition()), new OffsetAndMetadata(100L));
        this.consumer.commitSync(committedOffsets);
        this.restoreStateConsumer.updatePartitions("ktable1", Utils.mkList((Object[])new PartitionInfo[]{new PartitionInfo("ktable1", 0, Node.noNode(), new Node[0], new Node[0])}));
        TaskId taskId = new TaskId(0, 0);
        MockTime time = new MockTime();
        StreamsConfig config = this.createConfig(this.baseDir);
        StandbyTask task = new StandbyTask(taskId, "test-application", this.ktablePartitions, this.ktableTopology, this.consumer, (ChangelogReader)this.changelogReader, config, null, this.stateDirectory);
        task.initializeStateStores();
        this.restoreStateConsumer.assign(new ArrayList<TopicPartition>(task.checkpointedOffsets().keySet()));
        byte[] serializedValue = Serdes.Integer().serializer().serialize("", (Object)1);
        task.update(this.ktable, Collections.singletonList(new ConsumerRecord(this.ktable.topic(), this.ktable.partition(), 50L, (Object)serializedValue, (Object)serializedValue)));
        time.sleep(config.getLong("commit.interval.ms").longValue());
        task.commit();
        Map checkpoint = new OffsetCheckpoint(new File(this.stateDirectory.directoryForTask(taskId), ".checkpoint")).read();
        MatcherAssert.assertThat((Object)checkpoint, (Matcher)CoreMatchers.equalTo(Collections.singletonMap(this.ktable, 51L)));
    }

    private List<ConsumerRecord<byte[], byte[]>> records(ConsumerRecord<byte[], byte[]> ... recs) {
        return Arrays.asList(recs);
    }
}

