/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.processor.internals.MinTimestampTracker;
import org.apache.kafka.streams.processor.internals.Stamped;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class MinTimestampTrackerTest {
    private MinTimestampTracker<String> tracker = new MinTimestampTracker();

    @Test
    public void shouldReturnNotKnownTimestampWhenNoRecordsEverAdded() throws Exception {
        MatcherAssert.assertThat((Object)this.tracker.get(), (Matcher)CoreMatchers.equalTo((Object)-1L));
    }

    @Test
    public void shouldReturnTimestampOfOnlyRecord() throws Exception {
        this.tracker.addElement(this.elem(100L));
        MatcherAssert.assertThat((Object)this.tracker.get(), (Matcher)CoreMatchers.equalTo((Object)100L));
    }

    @Test
    public void shouldReturnLowestAvailableTimestampFromAllInputs() throws Exception {
        this.tracker.addElement(this.elem(100L));
        this.tracker.addElement(this.elem(99L));
        this.tracker.addElement(this.elem(102L));
        MatcherAssert.assertThat((Object)this.tracker.get(), (Matcher)CoreMatchers.equalTo((Object)99L));
    }

    @Test
    public void shouldReturnLowestAvailableTimestampAfterPreviousLowestRemoved() throws Exception {
        Stamped<String> lowest = this.elem(88L);
        this.tracker.addElement(lowest);
        this.tracker.addElement(this.elem(101L));
        this.tracker.addElement(this.elem(99L));
        this.tracker.removeElement(lowest);
        MatcherAssert.assertThat((Object)this.tracker.get(), (Matcher)CoreMatchers.equalTo((Object)99L));
    }

    @Test
    public void shouldReturnLastKnownTimestampWhenAllElementsHaveBeenRemoved() throws Exception {
        Stamped<String> record = this.elem(98L);
        this.tracker.addElement(record);
        this.tracker.removeElement(record);
        MatcherAssert.assertThat((Object)this.tracker.get(), (Matcher)CoreMatchers.equalTo((Object)98L));
    }

    @Test
    public void shouldIgnoreNullRecordOnRemove() throws Exception {
        this.tracker.removeElement(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionWhenTryingToAddNullElement() throws Exception {
        this.tracker.addElement(null);
    }

    private Stamped<String> elem(long timestamp) {
        return new Stamped((Object)"", timestamp);
    }
}

