/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.junit.Assert;
import org.junit.Test;

public class InternalTopicConfigTest {
    @Test
    public void shouldHaveCompactionPropSetIfSupplied() throws Exception {
        Properties properties = new InternalTopicConfig("name", Collections.singleton(InternalTopicConfig.CleanupPolicy.compact), Collections.emptyMap()).toProperties(0L);
        Assert.assertEquals((Object)"compact", (Object)properties.getProperty("cleanup.policy"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfNameIsNull() throws Exception {
        new InternalTopicConfig(null, Collections.singleton(InternalTopicConfig.CleanupPolicy.compact), Collections.emptyMap());
    }

    @Test(expected=InvalidTopicException.class)
    public void shouldThrowIfNameIsInvalid() throws Exception {
        new InternalTopicConfig("foo bar baz", Collections.singleton(InternalTopicConfig.CleanupPolicy.compact), Collections.emptyMap());
    }

    @Test
    public void shouldConfigureRetentionMsWithAdditionalRetentionWhenCompactAndDelete() throws Exception {
        InternalTopicConfig topicConfig = new InternalTopicConfig("name", Utils.mkSet((Object[])new InternalTopicConfig.CleanupPolicy[]{InternalTopicConfig.CleanupPolicy.compact, InternalTopicConfig.CleanupPolicy.delete}), Collections.emptyMap());
        int additionalRetentionMs = 20;
        topicConfig.setRetentionMs(10L);
        Properties properties = topicConfig.toProperties(20L);
        Assert.assertEquals((Object)"30", (Object)properties.getProperty("retention.ms"));
    }

    @Test
    public void shouldNotConfigureRetentionMsWhenCompact() throws Exception {
        InternalTopicConfig topicConfig = new InternalTopicConfig("name", Collections.singleton(InternalTopicConfig.CleanupPolicy.compact), Collections.emptyMap());
        topicConfig.setRetentionMs(10L);
        Properties properties = topicConfig.toProperties(0L);
        Assert.assertNull(null, (Object)properties.getProperty("retention.ms"));
    }

    @Test
    public void shouldNotConfigureRetentionMsWhenDelete() throws Exception {
        InternalTopicConfig topicConfig = new InternalTopicConfig("name", Collections.singleton(InternalTopicConfig.CleanupPolicy.delete), Collections.emptyMap());
        topicConfig.setRetentionMs(10L);
        Properties properties = topicConfig.toProperties(0L);
        Assert.assertNull(null, (Object)properties.getProperty("retention.ms"));
    }

    @Test
    public void shouldBeCompactedIfCleanupPolicyCompactOrCompactAndDelete() throws Exception {
        Assert.assertTrue((boolean)new InternalTopicConfig("name", Collections.singleton(InternalTopicConfig.CleanupPolicy.compact), Collections.emptyMap()).isCompacted());
        Assert.assertTrue((boolean)new InternalTopicConfig("name", Utils.mkSet((Object[])new InternalTopicConfig.CleanupPolicy[]{InternalTopicConfig.CleanupPolicy.compact, InternalTopicConfig.CleanupPolicy.delete}), Collections.emptyMap()).isCompacted());
    }

    @Test
    public void shouldNotBeCompactedWhenCleanupPolicyIsDelete() throws Exception {
        Assert.assertFalse((boolean)new InternalTopicConfig("name", Collections.singleton(InternalTopicConfig.CleanupPolicy.delete), Collections.emptyMap()).isCompacted());
    }

    @Test
    public void shouldUseCleanupPolicyFromConfigIfSupplied() throws Exception {
        InternalTopicConfig config = new InternalTopicConfig("name", Collections.singleton(InternalTopicConfig.CleanupPolicy.delete), Collections.singletonMap("cleanup.policy", "compact"));
        Properties properties = config.toProperties(0L);
        Assert.assertEquals((Object)"compact", (Object)properties.getProperty("cleanup.policy"));
    }

    @Test
    public void shouldHavePropertiesSuppliedByUser() throws Exception {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("retention.ms", "1000");
        configs.put("retention.bytes", "10000");
        InternalTopicConfig topicConfig = new InternalTopicConfig("name", Collections.singleton(InternalTopicConfig.CleanupPolicy.delete), configs);
        Properties properties = topicConfig.toProperties(0L);
        Assert.assertEquals((Object)"1000", (Object)properties.getProperty("retention.ms"));
        Assert.assertEquals((Object)"10000", (Object)properties.getProperty("retention.bytes"));
    }
}

