/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.DefaultPartitionGrouper;
import org.apache.kafka.streams.processor.TaskId;
import org.junit.Assert;
import org.junit.Test;

public class DefaultPartitionGrouperTest {
    private final List<PartitionInfo> infos = Arrays.asList(new PartitionInfo("topic1", 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic1", 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic1", 2, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic2", 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic2", 1, Node.noNode(), new Node[0], new Node[0]));
    private final Cluster metadata = new Cluster("cluster", Collections.singletonList(Node.noNode()), this.infos, Collections.emptySet(), Collections.emptySet());

    @Test
    public void shouldComputeGroupingForTwoGroups() {
        DefaultPartitionGrouper grouper = new DefaultPartitionGrouper();
        HashMap<TaskId, Set> expectedPartitionsForTask = new HashMap<TaskId, Set>();
        HashMap<Integer, Set> topicGroups = new HashMap<Integer, Set>();
        int topicGroupId = 0;
        topicGroups.put(topicGroupId, Utils.mkSet((Object[])new String[]{"topic1"}));
        expectedPartitionsForTask.put(new TaskId(topicGroupId, 0), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)}));
        expectedPartitionsForTask.put(new TaskId(topicGroupId, 1), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 1)}));
        expectedPartitionsForTask.put(new TaskId(topicGroupId, 2), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 2)}));
        topicGroups.put(++topicGroupId, Utils.mkSet((Object[])new String[]{"topic2"}));
        expectedPartitionsForTask.put(new TaskId(topicGroupId, 0), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)}));
        expectedPartitionsForTask.put(new TaskId(topicGroupId, 1), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic2", 1)}));
        Assert.assertEquals(expectedPartitionsForTask, (Object)grouper.partitionGroups(topicGroups, this.metadata));
    }

    @Test
    public void shouldComputeGroupingForSingleGroupWithMultipleTopics() {
        DefaultPartitionGrouper grouper = new DefaultPartitionGrouper();
        HashMap<TaskId, Set> expectedPartitionsForTask = new HashMap<TaskId, Set>();
        HashMap<Integer, Set> topicGroups = new HashMap<Integer, Set>();
        boolean topicGroupId = false;
        topicGroups.put(0, Utils.mkSet((Object[])new String[]{"topic1", "topic2"}));
        expectedPartitionsForTask.put(new TaskId(0, 0), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic2", 0)}));
        expectedPartitionsForTask.put(new TaskId(0, 1), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic2", 1)}));
        expectedPartitionsForTask.put(new TaskId(0, 2), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 2)}));
        Assert.assertEquals(expectedPartitionsForTask, (Object)grouper.partitionGroups(topicGroups, this.metadata));
    }

    @Test
    public void shouldNotCreateAnyTasksBecauseOneTopicHasUnknownPartitions() {
        DefaultPartitionGrouper grouper = new DefaultPartitionGrouper();
        HashMap expectedPartitionsForTask = new HashMap();
        HashMap<Integer, Set> topicGroups = new HashMap<Integer, Set>();
        boolean topicGroupId = false;
        topicGroups.put(0, Utils.mkSet((Object[])new String[]{"topic1", "unknownTopic", "topic2"}));
        Assert.assertEquals(expectedPartitionsForTask, (Object)grouper.partitionGroups(topicGroups, this.metadata));
    }
}

