/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.PrintForeachAction;
import org.apache.kafka.streams.kstream.internals.KStreamPrint;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.test.KStreamTestDriver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KStreamPrintTest {
    private final String topicName = "topic";
    private final Serde<Integer> intSerd = Serdes.Integer();
    private final Serde<String> stringSerd = Serdes.String();
    private PrintWriter printWriter;
    private ByteArrayOutputStream byteOutStream;
    private KStreamTestDriver driver = null;

    @Before
    public void setUp() {
        this.byteOutStream = new ByteArrayOutputStream();
        this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.byteOutStream, StandardCharsets.UTF_8));
    }

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
    }

    @Test
    public void testPrintKeyValueWithName() {
        KStreamPrint kStreamPrint = new KStreamPrint((ForeachAction)new PrintForeachAction(this.printWriter, "test-stream"), this.intSerd, this.stringSerd);
        List<KeyValue> inputRecords = Arrays.asList(new KeyValue((Object)0, (Object)"zero"), new KeyValue((Object)1, (Object)"one"), new KeyValue((Object)2, (Object)"two"), new KeyValue((Object)3, (Object)"three"));
        String[] expectedResult = new String[]{"[test-stream]: 0, zero", "[test-stream]: 1, one", "[test-stream]: 2, two", "[test-stream]: 3, three"};
        KStreamBuilder builder = new KStreamBuilder();
        KStream stream = builder.stream(this.intSerd, this.stringSerd, new String[]{"topic"});
        stream.process((ProcessorSupplier)kStreamPrint, new String[0]);
        this.driver = new KStreamTestDriver(builder);
        for (KeyValue record : inputRecords) {
            this.driver.process("topic", record.key, record.value);
        }
        this.printWriter.flush();
        String[] flushOutDatas = new String(this.byteOutStream.toByteArray(), Charset.forName("UTF-8")).split("\n");
        for (int i = 0; i < flushOutDatas.length; ++i) {
            Assert.assertEquals((Object)flushOutDatas[i], (Object)expectedResult[i]);
        }
    }
}

