/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.test.KStreamTestDriver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class KStreamPeekTest {
    private final String topicName = "topic";
    private final Serde<Integer> intSerd = Serdes.Integer();
    private final Serde<String> stringSerd = Serdes.String();
    private KStreamTestDriver driver = null;

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
    }

    @Test
    public void shouldObserveStreamElements() {
        KStreamBuilder builder = new KStreamBuilder();
        KStream stream = builder.stream(this.intSerd, this.stringSerd, new String[]{"topic"});
        ArrayList peekObserved = new ArrayList();
        ArrayList streamObserved = new ArrayList();
        stream.peek(KStreamPeekTest.collect(peekObserved)).foreach(KStreamPeekTest.collect(streamObserved));
        this.driver = new KStreamTestDriver(builder);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        for (int key = 0; key < 32; ++key) {
            String value = "V" + key;
            this.driver.process("topic", key, value);
            expected.add(new KeyValue((Object)key, (Object)value));
        }
        Assert.assertEquals(expected, peekObserved);
        Assert.assertEquals(expected, streamObserved);
    }

    @Test
    public void shouldNotAllowNullAction() {
        KStreamBuilder builder = new KStreamBuilder();
        KStream stream = builder.stream(this.intSerd, this.stringSerd, new String[]{"topic"});
        try {
            stream.peek(null);
            Assert.fail((String)"expected null action to throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static <K, V> ForeachAction<K, V> collect(final List<KeyValue<K, V>> into) {
        return new ForeachAction<K, V>(){

            public void apply(K key, V value) {
                into.add(new KeyValue(key, value));
            }
        };
    }
}

