/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class KStreamMapValuesTest {
    private String topicName = "topic";
    private final Serde<Integer> intSerde = Serdes.Integer();
    private final Serde<String> stringSerde = Serdes.String();
    private KStreamTestDriver driver;

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test
    public void testFlatMapValues() {
        KStreamBuilder builder = new KStreamBuilder();
        ValueMapper<CharSequence, Integer> mapper = new ValueMapper<CharSequence, Integer>(){

            public Integer apply(CharSequence value) {
                return value.length();
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream stream = builder.stream(this.intSerde, this.stringSerde, new String[]{this.topicName});
        stream.mapValues((ValueMapper)mapper).process(processor, new String[0]);
        this.driver = new KStreamTestDriver(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, Integer.toString(expectedKey));
        }
        Assert.assertEquals((long)4L, (long)processor.processed.size());
        String[] expected = new String[]{"1:1", "10:2", "100:3", "1000:4"};
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.processed.get(i));
        }
    }
}

