/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class KStreamFlatMapTest {
    private String topicName = "topic";
    private KStreamTestDriver driver = null;

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test
    public void testFlatMap() {
        KStreamBuilder builder = new KStreamBuilder();
        KeyValueMapper<Number, Object, Iterable<KeyValue<String, String>>> mapper = new KeyValueMapper<Number, Object, Iterable<KeyValue<String, String>>>(){

            public Iterable<KeyValue<String, String>> apply(Number key, Object value) {
                ArrayList<KeyValue<String, String>> result = new ArrayList<KeyValue<String, String>>();
                for (int i = 0; i < key.intValue(); ++i) {
                    result.add((KeyValue<String, String>)KeyValue.pair((Object)Integer.toString(key.intValue() * 10 + i), (Object)value.toString()));
                }
                return result;
            }
        };
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream stream = builder.stream(Serdes.Integer(), Serdes.String(), new String[]{this.topicName});
        stream.flatMap((KeyValueMapper)mapper).process(processor, new String[0]);
        this.driver = new KStreamTestDriver(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, "V" + expectedKey);
        }
        Assert.assertEquals((long)6L, (long)processor.processed.size());
        String[] expected = new String[]{"10:V1", "20:V2", "21:V2", "30:V3", "31:V3", "32:V3"};
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.processed.get(i));
        }
    }
}

