/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.test.MockProcessorSupplier;

public class MockProcessorNode<K, V>
extends ProcessorNode<K, V> {
    private static final String NAME = "MOCK-PROCESS-";
    private static final AtomicInteger INDEX = new AtomicInteger(1);
    public final MockProcessorSupplier<K, V> supplier;
    public boolean closed;
    public long punctuatedAt;
    public boolean initialized;

    public MockProcessorNode(long scheduleInterval) {
        this(new MockProcessorSupplier(scheduleInterval));
    }

    private MockProcessorNode(MockProcessorSupplier<K, V> supplier) {
        super(NAME + INDEX.getAndIncrement(), supplier.get(), Collections.emptySet());
        this.supplier = supplier;
    }

    public void init(ProcessorContext context) {
        super.init(context);
        this.initialized = true;
    }

    public void process(K key, V value) {
        this.processor().process(key, value);
    }

    public void punctuate(long timestamp) {
        super.punctuate(timestamp);
        this.punctuatedAt = timestamp;
    }

    public void close() {
        super.close();
        this.closed = true;
    }
}

