/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.util.List;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.Segments;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SegmentsTest {
    private static final int NUM_SEGMENTS = 5;
    private MockProcessorContext context;
    private Segments segments;

    @Before
    public void createContext() {
        this.context = new MockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), new NoOpRecordCollector(), new ThreadCache("testCache", 0L, (StreamsMetrics)new MockStreamsMetrics(new Metrics())));
        this.segments = new Segments("test", 240000L, 5);
    }

    @After
    public void close() {
        this.context.close();
        this.segments.close();
    }

    @Test
    public void shouldGetSegmentIdsFromTimestamp() throws Exception {
        Assert.assertEquals((long)0L, (long)this.segments.segmentId(0L));
        Assert.assertEquals((long)1L, (long)this.segments.segmentId(60000L));
        Assert.assertEquals((long)2L, (long)this.segments.segmentId(120000L));
        Assert.assertEquals((long)3L, (long)this.segments.segmentId(180000L));
    }

    @Test
    public void shouldBaseSegmentIntervalOnRetentionAndNumSegments() throws Exception {
        Segments segments = new Segments("test", 480000L, 5);
        Assert.assertEquals((long)0L, (long)segments.segmentId(0L));
        Assert.assertEquals((long)0L, (long)segments.segmentId(60000L));
        Assert.assertEquals((long)1L, (long)segments.segmentId(120000L));
    }

    @Test
    public void shouldGetSegmentNameFromId() throws Exception {
        Assert.assertEquals((Object)"test-197001010000", (Object)this.segments.segmentName(0L));
        Assert.assertEquals((Object)"test-197001010001", (Object)this.segments.segmentName(1L));
        Assert.assertEquals((Object)"test-197001010002", (Object)this.segments.segmentName(2L));
    }

    @Test
    public void shouldCreateSegments() throws Exception {
        Segment segment1 = this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        Segment segment2 = this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        Segment segment3 = this.segments.getOrCreateSegment(2L, (ProcessorContext)this.context);
        Assert.assertTrue((boolean)new File(this.context.stateDir(), "test/test-197001010000").isDirectory());
        Assert.assertTrue((boolean)new File(this.context.stateDir(), "test/test-197001010001").isDirectory());
        Assert.assertTrue((boolean)new File(this.context.stateDir(), "test/test-197001010002").isDirectory());
        Assert.assertEquals((Object)true, (Object)segment1.isOpen());
        Assert.assertEquals((Object)true, (Object)segment2.isOpen());
        Assert.assertEquals((Object)true, (Object)segment3.isOpen());
    }

    @Test
    public void shouldNotCreateSegmentThatIsAlreadyExpired() throws Exception {
        this.segments.getOrCreateSegment(7L, (ProcessorContext)this.context);
        Assert.assertNull((Object)this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context));
        Assert.assertFalse((boolean)new File(this.context.stateDir(), "test/test-197001010000").exists());
    }

    @Test
    public void shouldCleanupSegmentsThatHaveExpired() throws Exception {
        Segment segment1 = this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        Segment segment2 = this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        Segment segment3 = this.segments.getOrCreateSegment(7L, (ProcessorContext)this.context);
        Assert.assertFalse((boolean)segment1.isOpen());
        Assert.assertFalse((boolean)segment2.isOpen());
        Assert.assertTrue((boolean)segment3.isOpen());
        Assert.assertFalse((boolean)new File(this.context.stateDir(), "test/test-197001010000").exists());
        Assert.assertFalse((boolean)new File(this.context.stateDir(), "test/test-197001010001").exists());
        Assert.assertTrue((boolean)new File(this.context.stateDir(), "test/test-197001010007").exists());
    }

    @Test
    public void shouldGetSegmentForTimestamp() throws Exception {
        Segment segment = this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        Assert.assertEquals((Object)segment, (Object)this.segments.getSegmentForTimestamp(0L));
    }

    @Test
    public void shouldCloseAllOpenSegments() throws Exception {
        Segment first = this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        Segment second = this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        Segment third = this.segments.getOrCreateSegment(2L, (ProcessorContext)this.context);
        this.segments.close();
        Assert.assertFalse((boolean)first.isOpen());
        Assert.assertFalse((boolean)second.isOpen());
        Assert.assertFalse((boolean)third.isOpen());
    }

    @Test
    public void shouldOpenExistingSegments() throws Exception {
        this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(2L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(3L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(4L, (ProcessorContext)this.context);
        this.segments.close();
        this.segments = new Segments("test", 240000L, 5);
        this.segments.openExisting((ProcessorContext)this.context);
        Assert.assertTrue((boolean)this.segments.getSegmentForTimestamp(0L).isOpen());
        Assert.assertTrue((boolean)this.segments.getSegmentForTimestamp(1L).isOpen());
        Assert.assertTrue((boolean)this.segments.getSegmentForTimestamp(2L).isOpen());
        Assert.assertTrue((boolean)this.segments.getSegmentForTimestamp(3L).isOpen());
        Assert.assertTrue((boolean)this.segments.getSegmentForTimestamp(4L).isOpen());
    }

    @Test
    public void shouldGetSegmentsWithinTimeRange() throws Exception {
        this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(2L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(3L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(4L, (ProcessorContext)this.context);
        List segments = this.segments.segments(0L, 120000L);
        Assert.assertEquals((long)3L, (long)segments.size());
        Assert.assertEquals((long)0L, (long)((Segment)segments.get((int)0)).id);
        Assert.assertEquals((long)1L, (long)((Segment)segments.get((int)1)).id);
        Assert.assertEquals((long)2L, (long)((Segment)segments.get((int)2)).id);
    }

    @Test
    public void shouldGetSegmentsWithinTimeRangeOutOfOrder() throws Exception {
        this.segments.getOrCreateSegment(4L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(2L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(3L, (ProcessorContext)this.context);
        List segments = this.segments.segments(0L, 120000L);
        Assert.assertEquals((long)3L, (long)segments.size());
        Assert.assertEquals((long)0L, (long)((Segment)segments.get((int)0)).id);
        Assert.assertEquals((long)1L, (long)((Segment)segments.get((int)1)).id);
        Assert.assertEquals((long)2L, (long)((Segment)segments.get((int)2)).id);
    }

    @Test
    public void shouldRollSegments() throws Exception {
        this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(0L, 1);
        this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(0L, 2);
        this.segments.getOrCreateSegment(2L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(0L, 3);
        this.segments.getOrCreateSegment(3L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(0L, 4);
        this.segments.getOrCreateSegment(4L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(0L, 5);
        this.segments.getOrCreateSegment(5L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(1L, 5);
        this.segments.getOrCreateSegment(6L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(2L, 5);
    }

    private void verifyCorrectSegments(long first, int numSegments) {
        List result = this.segments.segments(0L, Long.MAX_VALUE);
        Assert.assertEquals((long)numSegments, (long)result.size());
        for (int i = 0; i < numSegments; ++i) {
            Assert.assertEquals((long)((long)i + first), (long)((Segment)result.get((int)i)).id);
        }
    }
}

