/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.rocksdb.Options;

public class RocksDBStoreTest {
    private final File tempDir = TestUtils.tempDirectory();
    private RocksDBStore<String, String> subject;

    @Before
    public void setUp() throws Exception {
        this.subject = new RocksDBStore("test", Serdes.String(), Serdes.String());
    }

    @After
    public void tearDown() throws Exception {
        this.subject.close();
    }

    @Test
    public void canSpecifyConfigSetterAsClass() throws Exception {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("rocksdb.config.setter", MockRocksDbConfigSetter.class);
        MockRocksDbConfigSetter.called = false;
        this.subject.openDB((ProcessorContext)new ConfigurableProcessorContext(this.tempDir, Serdes.String(), Serdes.String(), null, null, configs));
        Assert.assertTrue((boolean)MockRocksDbConfigSetter.called);
    }

    @Test
    public void canSpecifyConfigSetterAsString() throws Exception {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("rocksdb.config.setter", MockRocksDbConfigSetter.class.getName());
        MockRocksDbConfigSetter.called = false;
        this.subject.openDB((ProcessorContext)new ConfigurableProcessorContext(this.tempDir, Serdes.String(), Serdes.String(), null, null, configs));
        Assert.assertTrue((boolean)MockRocksDbConfigSetter.called);
    }

    private static class ConfigurableProcessorContext
    extends MockProcessorContext {
        final Map<String, Object> configs;

        ConfigurableProcessorContext(File stateDir, Serde<?> keySerde, Serde<?> valSerde, RecordCollector collector, ThreadCache cache, Map<String, Object> configs) {
            super(stateDir, keySerde, valSerde, collector, cache);
            this.configs = configs;
        }

        @Override
        public Map<String, Object> appConfigs() {
            return this.configs;
        }
    }

    public static class MockRocksDbConfigSetter
    implements RocksDBConfigSetter {
        static boolean called;

        public void setConfig(String storeName, Options options, Map<String, Object> configs) {
            called = true;
        }
    }
}

