/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.NoOpWindowStore;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.internals.GlobalStateStoreProvider;
import org.apache.kafka.streams.state.internals.QueryableStoreProvider;
import org.apache.kafka.test.NoOpReadOnlyStore;
import org.apache.kafka.test.StateStoreProviderStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryableStoreProviderTest {
    private final String keyValueStore = "key-value";
    private final String windowStore = "window-store";
    private QueryableStoreProvider storeProvider;
    private HashMap<String, StateStore> globalStateStores;

    @Before
    public void before() {
        StateStoreProviderStub theStoreProvider = new StateStoreProviderStub(false);
        theStoreProvider.addStore("key-value", new NoOpReadOnlyStore());
        theStoreProvider.addStore("window-store", new NoOpWindowStore());
        this.globalStateStores = new HashMap();
        this.storeProvider = new QueryableStoreProvider(Collections.singletonList(theStoreProvider), new GlobalStateStoreProvider(this.globalStateStores));
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionIfKVStoreDoesntExist() throws Exception {
        this.storeProvider.getStore("not-a-store", QueryableStoreTypes.keyValueStore());
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionIfWindowStoreDoesntExist() throws Exception {
        this.storeProvider.getStore("not-a-store", QueryableStoreTypes.windowStore());
    }

    @Test
    public void shouldReturnKVStoreWhenItExists() throws Exception {
        Assert.assertNotNull((Object)this.storeProvider.getStore("key-value", QueryableStoreTypes.keyValueStore()));
    }

    @Test
    public void shouldReturnWindowStoreWhenItExists() throws Exception {
        Assert.assertNotNull((Object)this.storeProvider.getStore("window-store", QueryableStoreTypes.windowStore()));
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionWhenLookingForWindowStoreWithDifferentType() throws Exception {
        this.storeProvider.getStore("window-store", QueryableStoreTypes.keyValueStore());
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionWhenLookingForKVStoreWithDifferentType() throws Exception {
        this.storeProvider.getStore("key-value", QueryableStoreTypes.windowStore());
    }

    @Test
    public void shouldFindGlobalStores() throws Exception {
        this.globalStateStores.put("global", new NoOpReadOnlyStore());
        Assert.assertNotNull((Object)this.storeProvider.getStore("global", QueryableStoreTypes.keyValueStore()));
    }
}

