/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.Iterator;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheWindowStoreKeyValueIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class MergedSortedCacheWrappedWindowStoreKeyValueIteratorTest {
    private static final SegmentedCacheFunction SINGLE_SEGMENT_CACHE_FUNCTION = new SegmentedCacheFunction(null, -1L){

        public long segmentId(Bytes key) {
            return 0L;
        }
    };
    private static final int WINDOW_SIZE = 10;
    private final String storeKey = "a";
    private final String cacheKey = "b";
    private final TimeWindow storeWindow = new TimeWindow(0L, 1L);
    private final Iterator<KeyValue<Windowed<Bytes>, byte[]>> storeKvs = Collections.singleton(KeyValue.pair((Object)new Windowed((Object)Bytes.wrap((byte[])"a".getBytes()), (Window)this.storeWindow), (Object)"a".getBytes())).iterator();
    private final TimeWindow cacheWindow = new TimeWindow(10L, 20L);
    private final Iterator<KeyValue<Bytes, LRUCacheEntry>> cacheKvs = Collections.singleton(KeyValue.pair((Object)SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(WindowStoreUtils.toBinaryKey((Object)"b", (long)this.cacheWindow.start(), (int)0, (StateSerdes)new StateSerdes("dummy", Serdes.String(), Serdes.String()))), (Object)new LRUCacheEntry("b".getBytes()))).iterator();

    @Test
    public void shouldHaveNextFromStore() throws Exception {
        MergedSortedCacheWindowStoreKeyValueIterator<String, String> mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator());
        Assert.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldGetNextFromStore() throws Exception {
        MergedSortedCacheWindowStoreKeyValueIterator<String, String> mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator());
        MatcherAssert.assertThat((Object)mergeIterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"a", (Window)this.storeWindow), (Object)"a")));
    }

    @Test
    public void shouldPeekNextKeyFromStore() throws Exception {
        MergedSortedCacheWindowStoreKeyValueIterator<String, String> mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator());
        MatcherAssert.assertThat((Object)mergeIterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)"a", (Window)this.storeWindow)));
    }

    @Test
    public void shouldHaveNextFromCache() throws Exception {
        MergedSortedCacheWindowStoreKeyValueIterator<String, String> mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs);
        Assert.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldGetNextFromCache() throws Exception {
        MergedSortedCacheWindowStoreKeyValueIterator<String, String> mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs);
        MatcherAssert.assertThat((Object)mergeIterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"b", (Window)this.cacheWindow), (Object)"b")));
    }

    @Test
    public void shouldPeekNextKeyFromCache() throws Exception {
        MergedSortedCacheWindowStoreKeyValueIterator<String, String> mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs);
        MatcherAssert.assertThat((Object)mergeIterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)"b", (Window)this.cacheWindow)));
    }

    @Test
    public void shouldIterateBothStoreAndCache() throws Exception {
        MergedSortedCacheWindowStoreKeyValueIterator<String, String> iterator = this.createIterator(this.storeKvs, this.cacheKvs);
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"a", (Window)this.storeWindow), (Object)"a")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"b", (Window)this.cacheWindow), (Object)"b")));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private MergedSortedCacheWindowStoreKeyValueIterator<String, String> createIterator(Iterator<KeyValue<Windowed<Bytes>, byte[]>> storeKvs, Iterator<KeyValue<Bytes, LRUCacheEntry>> cacheKvs) {
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(storeKvs));
        DelegatingPeekingKeyValueIterator cacheIterator = new DelegatingPeekingKeyValueIterator("cache", new KeyValueIteratorStub(cacheKvs));
        return new MergedSortedCacheWindowStoreKeyValueIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, new StateSerdes("name", Serdes.String(), Serdes.String()), 10L, SINGLE_SEGMENT_CACHE_FUNCTION);
    }
}

